package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName("ice_charge_24charge_set")
public class Charge24ChargeSet implements Serializable {
    /** id */
    @TableId(type = IdType.AUTO)
    protected Integer id;
    /** 计费规则编号 时间+随机数小于16位 */
    protected String billtypecode;
    /** 计费规则名称 */
    protected String billtypename;
    /** 车场id */
    protected Integer parkId;
    /** 免费时长（分钟） */
    protected Integer freetime;
    /** 是否使用一天最大收费限额(一天) 0：禁用  1：启用 默认为0 */
    protected Integer daynightmaxfeeusing;
    /** 单天最高收费金额 元 */
    protected BigDecimal daynightmaxfee;
    /** 时间分割方式 分钟 */
    protected Integer divisionTime;
    /** 是否启用跨天后收费 1是 2否 默认否 */
    protected Integer isOverTimeSet;
    /** 跨天后每间隔多长时间 分钟 */
    protected Integer feespantimestep;
    /** 跨天后单位费用 元 */
    protected BigDecimal feespanratestep;
    /** 状态（0：正常，1：删除，默认0） */
    protected Integer status;
    /** 备注 */
    protected String remark;
    /** 添加人 */
    protected String adder;
    /** 添加时间 */
    protected LocalDateTime addtime;
    /** 最后修改人 */
    protected String updateUser;
    /** 更新时间 */
    protected LocalDateTime updateTime;
    /** 大型车单天最高收费金额 元 */
    protected BigDecimal daynightmaxfeeBig;
    /** 大型车跨天后单位费用 元 */
    protected BigDecimal feespanratestepBig;
    /** 是否区分大小型车计费（0：否，1：是） */
    protected Integer isSmallbigcarSet;
    /** 最高收费类型  1=单天单次最高收费 2=单天最高收费 3=24小时最高收费 */
    protected Integer maxfeetype;
    /** 24小时统计方式 1=以24小时内的订单入场时间为准 2=以24小时之内的出场时间判断 */
    protected Integer counttype;
}
