/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.city.road.utils;

import jakarta.annotation.Nullable;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    public static final String SHORT_DATE_PATTERN = "yyyyMMdd";
    public static final String DEFAULT_TIME_PATTERN = "HH:mm:ss";
    public static final String SHORT_TIME_PATTERN = "HHmmss";
    public static final String DEFAULT_TIME_HM_PATTERN = "HH:mm";
    public static final String SHORT_TIME_HM_PATTERN = "HHmm";
    public static final String DEFAULT_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String SHORT_DATETIME_PATTERN = "yyyyMMddHHmmss";
    public static final DateTimeFormatter DEFAULT_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter DEFAULT_TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss");
    public static final DateTimeFormatter DEFAULT_DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final String DEFAULT_ZONE_VALUE = "+8";
    public static final ZoneId DEFAULT_ZONE_ID = ZoneId.of("+8");
    public static final Clock DEFAULT_CLOCK = Clock.system(DEFAULT_ZONE_ID);
    public static final ZoneOffset DEFAULT_ZONE_OFFSET = ZoneOffset.of("+8");
    public static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getTimeZone(DEFAULT_ZONE_ID);
    public static final int MINUTE_OF_DAY = 1440;
    public static final int SECOND_OF_DAY = 86400;
    public static final long MIN_MILLI_TIMESTAMP = 1000000000000L;

    public static long toEpochSecond(LocalDateTime localDateTime) {
        return localDateTime.toEpochSecond(DEFAULT_ZONE_OFFSET);
    }

    public static long toEpochMilli(LocalDateTime localDateTime) {
        return localDateTime.toInstant(DEFAULT_ZONE_OFFSET).toEpochMilli();
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return date.toInstant().atOffset(DEFAULT_ZONE_OFFSET).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(long milli) {
        return Instant.ofEpochMilli(milli).atZone(DEFAULT_ZONE_OFFSET).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTimeOfSecond(long second) {
        return LocalDateTime.ofEpochSecond(second, 0, DEFAULT_ZONE_OFFSET);
    }

    public static LocalDate toLocalDate(Date date) {
        return date.toInstant().atOffset(DEFAULT_ZONE_OFFSET).toLocalDate();
    }

    public static LocalTime toLocalTime(Date date) {
        return date.toInstant().atOffset(DEFAULT_ZONE_OFFSET).toLocalTime();
    }

    public static LocalTime toLocalTimeOfSecond(long second) {
        return Instant.ofEpochSecond(second).atZone(DEFAULT_ZONE_OFFSET).toLocalTime();
    }

    public static boolean betweenOfSecond(LocalTime time, LocalTime startTime, LocalTime endTime) {
        int endSecond;
        int second = time.toSecondOfDay();
        int startSecond = startTime.toSecondOfDay();
        return startSecond < (endSecond = endTime.toSecondOfDay()) ? second >= startSecond && second <= endSecond : second >= startSecond && second <= 86400 || second >= 0 && second <= endSecond;
    }

    public static boolean betweenOfMinute(LocalTime time, LocalTime startTime, LocalTime endTime) {
        int endMinute;
        int minute = time.toSecondOfDay() / 60;
        int startMinute = startTime.toSecondOfDay() / 60;
        return startMinute < (endMinute = endTime.toSecondOfDay() / 60) ? minute >= startMinute && minute <= endMinute : minute >= startMinute && minute <= 1440 || minute >= 0 && minute <= endMinute;
    }

    public static String formatDurationOfNow(long unixTime) {
        return DateUtils.formatDurationOfSecond(unixTime, System.currentTimeMillis() / 1000L);
    }

    public static String formatDurationOfSecond(long startUnixTime, long stopUnixTime) {
        return DateUtils.formatDurationOfSecond(stopUnixTime - startUnixTime);
    }

    public static String formatDurationOfSecond(long second) {
        String timeStr = "";
        long days = second / 86400L;
        long hours = (second - 86400L * days) / 3600L;
        long minutes = (second - 86400L * days - 3600L * hours) / 60L;
        if (days > 0L) {
            timeStr = String.format("%d\u5929", days);
        }
        if (hours > 0L) {
            timeStr = timeStr + String.format("%d\u5c0f\u65f6", hours);
        }
        timeStr = timeStr + String.format("%d\u5206\u949f", minutes);
        return timeStr;
    }

    public static String formatDurationOfSecond2(long second) {
        String timeStr = "";
        long days = second / 86400L;
        long hours = (second - 86400L * days) / 3600L;
        long minutes = (second - 86400L * days - 3600L * hours) / 60L;
        long surplus = second - 86400L * days - 3600L * hours - 60L * minutes;
        if (days > 0L) {
            timeStr = String.format("%d\u5929", days);
        }
        if (hours > 0L) {
            timeStr = timeStr + String.format("%d\u5c0f\u65f6", hours);
        }
        if (minutes > 0L) {
            timeStr = timeStr + String.format("%d\u5206\u949f", minutes);
        }
        timeStr = timeStr + String.format("%d\u79d2", surplus);
        return timeStr;
    }

    public static String formatDurationOfMinute(long minute) {
        String timeStr = "";
        long days = minute / 1440L;
        long hours = (minute - 1440L * days) / 60L;
        long minutes = minute - 1440L * days - 60L * hours;
        if (days > 0L) {
            timeStr = String.format("%d\u5929", days);
        }
        if (hours > 0L) {
            timeStr = timeStr + String.format("%d\u5c0f\u65f6", hours);
        }
        timeStr = timeStr + String.format("%d\u5206\u949f", minutes);
        return timeStr;
    }

    @Nullable
    public static Date timestampToDate(@Nullable Long timestamp) {
        Date date = null;
        if (timestamp != null) {
            date = new Date(timestamp < 1000000000000L ? timestamp * 1000L : timestamp);
        }
        return date;
    }

    public static long currentTimeSecond() {
        return System.currentTimeMillis() / 1000L;
    }

    public static int getMonthDays(int year, int month) {
        if (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) {
            return 31;
        }
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            return 30;
        }
        if (month == 2) {
            return year % 4 == 0 ? 29 : 28;
        }
        throw new IllegalArgumentException("Invalid month: " + month);
    }

    public static LocalDate atFirstDayOfMonth(LocalDate date) {
        return date.withDayOfMonth(1);
    }

    public static LocalDate atLastDayOfMonth(LocalDate date) {
        return date.withDayOfMonth(DateUtils.getMonthDays(date.getYear(), date.getMonthValue()));
    }

    public static Date getBeforeYear(int year) {
        return Date.from(LocalDateTime.now().minusYears(year).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getEndOfDay(Date date) {
        LocalDateTime endOfDay = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().atTime(LocalTime.MAX);
        return Date.from(endOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getStartOfDay(Date date) {
        LocalDateTime startOfDay = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().atStartOfDay();
        return Date.from(startOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static long parseToTimestamp(String timeStr) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(SHORT_DATETIME_PATTERN);
        LocalDateTime localDateTime = LocalDateTime.parse(timeStr, formatter);
        return localDateTime.atZone(ZoneId.systemDefault()).toEpochSecond();
    }
}

