package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 *  实体类
 */
@Data
@TableName("ice_special")
public class Special implements Serializable {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 车牌
     */
    @TableField("plate_num")
    private String plateNum;
    /**
     * 车牌颜色 0-未知, 1-蓝底白字, 2-黄底黑字, 3-白底黑字, 4-黑底白字, 5-绿底黑字 6-绿黄底黑字
     */
    @TableField("plate_color")
    private Integer plateColor;
    /**
     * 车主姓名
     */
    @TableField("user_name")
    private String userName;
    /**
     * 联系电话
     */
    @TableField("phone")
    private String phone;
    /**
     * 状态：0-禁用，1-启用
     */
    @TableField("status")
    private Integer status;
    /**
     * 操作人
     */
    @TableField("create_user")
    private String createUser;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
    /**
     * 推送地址
     */
    @TableField("push_url")
    private String pushUrl;
    /**
     * 备注
     */
    @TableField("remark")
    private String remark;
}