package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 数据下发表 实体类
 * @author wgq
 */
@Data
@TableName("ice_sendinfo")
public class SendInfo implements Serializable {

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    /**
     * 
     */
    @TableField("park_id")
    private Long parkId;
    /**
     * 优先级
     */
    @TableField("level")
    private Integer level;
    /**
     * 业务类型（1月卡 2云预缴费）
     */
    @TableField("service_type")
    private Integer serviceType;
    /**
     * 业务id  如业务类型为1此类为月卡操作记录表的ID； 
     */
    @TableField("service_id")
    private Integer serviceId;
    /**
     * 状态(0待下发1成功2暂不下发3延迟下发4失败，默认0
     */
    @TableField("status")
    private Integer status;
    /**
     * 是否下发（0未下发，1已下发，2错误，默认0）
     */
    @TableField("send_type")
    private Integer sendType;
    /**
     * 发送次数
     */
    @TableField("send_num")
    private Integer sendNum;
    /**
     * 下次执行时间
     */
    @TableField("next_fire_time")
    private Integer nextFireTime;
    /**
     * 人工下发操作人 针对月卡的操作
     */
    @TableField("update_user")
    private String updateUser;
    /**
     * 备注 重点记录下发失败的原因
     */
    @TableField("remark")
    private String remark;
    /**
     * 备注 特殊业务参数
     */
    @TableField("special_param")
    private String specialParam;
    /**
     * 目标服务
     */
    @TableField("target_service")
    private Integer targetService;
    /**
     * 包含的标识，多个推送对象时需要
     */
    @TableField("include")
    private String include;
    /**
     * 车场响应时间
     */
    @TableField("ret_time")
    private Date retTime;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;
}