package com.icetech.city.common.domain.dto;

import com.icetech.city.common.domain.entity.common.SpecCarPlate;
import lombok.*;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

@Getter
@Setter
@ToString(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class SpecCarInfoDto {

    /**
     * 优惠类型Id
     */
    private Integer typeId;

    /**
     * 车牌
     */
    private String plateNum;

    /**
     * 所有车牌
     */
    private List<SpecCarPlate> carPlates;

    /**
     * 姓名
     */
    private String ownerName;

    /**
     * 电话
     */
    private String ownerPhone;

    /**
     * 有效状态(0-未生效;1-已生效;2-已过期)
     */
    private Integer validState;

    /**
     * 开始日期
     */
    private Date beginDate;

    /**
     * 结束日期
     */
    private Date endDate;

}
