package com.icetech.city.common.api;

import com.icetech.city.common.domain.dto.SpecCarTypeDto;
import com.icetech.city.common.domain.entity.common.SpecCarType;

public interface SpecCarTypeApi {

    /**
     * 通过优惠类型ID查询优惠类型信息
     *
     * @param typeId 优惠类型ID
     * @return 优惠类型
     */
    SpecCarTypeDto getSpecCarTypeByTypeId(Integer typeId);

    /**
     * 通过优惠信息的ID获取优惠类型
     *
     * @param carInfoId 优惠车辆ID
     * @return SpecCarType
     */
    SpecCarType getSpecCarTypeByCarInfoId(Integer carInfoId);
}
