package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 宁波银行财资转账记录表 实体类
 */
@Data
@TableName("ice_transaction_log")
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class TransactionLog implements Serializable {


    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 车场id
     */
    @TableField("park_id")
    private Long parkId;
    /**
     * 车场编号
     */
    @TableField("park_code")
    private String parkCode;
    /**
     * 车场类型:1场库;2路内
     */
    @TableField("park_type")
    private Integer parkType;
    /**
     * 转账金额
     */
    @TableField("amount")
    private BigDecimal amount;
    /**
     * 实际转账金额
     */
    @TableField("real_amount")
    private BigDecimal realAmount;
    /**
     * 银行单号
     */
    @TableField("bank_id")
    private String bankId;
    /**
     * 状态:0:待转账;1已转账;2转账失败;3转账中
     */
    @TableField("status")
    private Integer status;
    /**
     * 失败原因
     */
    @TableField("fail_msg")
    private String failMsg;
    /**
     * 备注
     */
    @TableField("remark")
    private String remark;
    /**
     * 标识:0正常;1退款比支付 多
     */
    @TableField("flag")
    private Integer flag;
    /**
     * 转账成功时间
     */
    @TableField("success_time")
    private Date successTime;
    /**
     * 转账编码
     */
    @TableField("code")
    private String code;

    /**
     * 转账规则id
     */
    @TableField("transfer_id")
    private Long transferId;
    /**
     * 周期
     */
    @TableField("cycle")
    private String cycle;
    /**
     * 临停支付总比数
     */
    @TableField("temp_total_num")
    private Integer tempTotalNum;
    /**
     * 临停总支付金额
     */
    @TableField("temp_total_pay_amount")
    private BigDecimal tempTotalPayAmount;

    /**
     * 临停退款金额
     */
    @TableField("temp_refund_amount")
    private BigDecimal tempRefundAmount;

    /**
     * 临停电子支付金额
     */
    @TableField("temp_electron_pay_amount")
    private BigDecimal tempElectronPayAmount;
    /**
     * 临停ETC支付金额
     */
    @TableField("temp_etc_pay_amount")
    private BigDecimal tempEtcPayAmount;
    /**
     * 临停现金支付金额
     */
    @TableField("temp_cash_pay_amount")
    private BigDecimal tempCashPayAmount;
    /**
     * 月卡总支付笔数
     */
    @TableField("month_total_num")
    private Integer monthTotalNum;
    /**
     * 月卡总支付金额
     */
    @TableField("month_total_pay_amount")
    private BigDecimal monthTotalPayAmount;

    /**
     * 月卡退款金额
     */
    @TableField("month_refund_amount")
    private BigDecimal monthRefundAmount;

    /**
     * 月卡线上支付金额
     */
    @TableField("month_electron_pay_amount")
    private BigDecimal monthElectronPayAmount;
    /**
     * 月卡线下支付金额
     */
    @TableField("month_cash_pay_amount")
    private BigDecimal monthCashPayAmount;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 转账时间
     */
    @TableField(value = "transaction_time", fill = FieldFill.INSERT)
    private Date transactionTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;
    /**
     * 删除标志:0未删除;1已删除
     */
    @TableField("deleted")
    private Integer deleted;
}