package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;

/**
 * 特殊车辆信息 实体类
 */
@Data
@TableName("ice_spec_car_info")
public class SpecCarInfo implements Serializable {

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    /**
     * 类型ID
     */
    @TableField("type_id")
    private Integer typeId;
    /**
     * 所属人姓名
     */
    @TableField("owner_name")
    private String ownerName;
    /**
     * 所属人手机
     */
    @TableField("owner_phone")
    private String ownerPhone;
    /**
     * 开始日期
     */
    @TableField("begin_date")
    private Date beginDate;
    /**
     * 结束日期
     */
    @TableField("end_date")
    private Date endDate;
    /**
     * 启用标识(0/1)
     */
    @TableField("enable_flag")
    private Integer enableFlag;
    /**
     * 备注
     */
    @TableField("remark")
    private String remark;
    /**
     * 创建人
     */
    @TableField("create_user")
    private String createUser;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;
    /**
     * 修改人
     */
    @TableField("update_user")
    private String updateUser;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;
}