package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 月卡购买记录表 实体类
 */
@Data
@TableName("ice_month_pay_record")
public class RoadMonthPayRecord implements Serializable {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    /**
     * 月卡ID
     */
    @TableField("month_id")
    private Integer monthId;
    /**
     * 月卡套餐ID
     */
    @TableField("product_id")
    private Integer productId;
    /**
     * 车牌号
     */
    @TableField("plate_num")
    private String plateNum;
    /**
     * 支付渠道 1:云平台办理;2:小程序
     */
    @TableField("pay_channel")
    private Integer payChannel;
    /**
     * 支付时间
     */
    @TableField("pay_time")
    private Long payTime;
    /**
     * 支付金额
     */
    @TableField("pay_amount")
    private BigDecimal payAmount;
    /**
     * 使用开始时间
     */
    @TableField("use_begin_date")
    private Date useBeginDate;
    /**
     * 使用结束时间
     */
    @TableField("use_end_date")
    private Date useEndDate;
    /**
     * 购买年月
     */
    @TableField("pay_year_month")
    private String payYearMonth;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;
    /**
     * 交易流水号
     */
    @TableField("trade_no")
    private String tradeNo;
    /**
     * 月卡操作记录id
     */
    @TableField("month_record_id")
    private Integer monthRecordId;
}