package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单欠费记录表 实体类
 */
@Data
@TableName("ice_order_notpay")
public class GarageOrderNotPay implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 订单号
     */
    @TableField("order_num")
    private String orderNum;

    /**
     * 车场id
     */
    @TableField("park_id")
    private Integer parkId;

    /**
     * 车牌号
     */
    @TableField("plate_num")
    private String plateNum;

    /**
     * 车辆类型(1临时车2月卡车3特殊车辆，默认1)
     */
    @TableField("type")
    private Integer type;

    /**
     * 进场时间
     */
    @TableField("enter_time")
    private Integer enterTime;

    /**
     * 离场时间
     */
    @TableField("exit_time")
    private Integer exitTime;

    /**
     * 车型(2大型车、1小型车，默认1)
     */
    @TableField("car_type")
    private Integer carType;

    /**
     * 欠费金额
     */
    @TableField("total_price")
    private BigDecimal totalPrice;

    /**
     * 补缴金额
     */
    @TableField("paid_price")
    private BigDecimal paidPrice;

    /**
     * 优惠金额
     */
    @TableField("discount_price")
    private BigDecimal discountPrice;

    /**
     * 状态（1未补缴、2已补缴、3已删除、4待审核、5已取消）
     */
    @TableField("status")
    private Integer status;

    /**
     * 补缴类型，1：入口补缴、2：出口补缴
     */
    @TableField("mend_pay_type")
    private Integer mendPayType;

    /**
     * 补缴通道名称
     */
    @TableField("channel_name")
    private String channelName;

    /**
     * 通道ID
     */
    @TableField("channel_id")
    private Integer channelId;

    /**
     * 操作员
     */
    @TableField("oper_account")
    private String operAccount;

    /**
     * 上次缴费时间
     */
    @TableField("last_pay_time")
    private Integer lastPayTime;

    /**
     * 删除/补缴时间
     */
    @TableField("oper_time")
    private Date operTime;

    /**
     * 视频ID
     */
    @TableField("video_id")
    private String videoId;

    /**
     * 视频证据地址
     */
    @TableField("evidence_video")
    private String evidenceVideo;

    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 操作原因
     */
    @TableField("oper_reason")
    private String operReason;
}