package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 月卡信息表 实体类
 */
@Data
@TableName("ice_month_info")
public class GarageMonthInfo implements Serializable {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    /**
     * 车场id
     */
    @TableField("park_id")
    private Integer parkId;
    /**
     * 申办性质 1个人 2公司
     */
    @TableField("card_property")
    private Integer cardProperty;
    /**
     * 月卡所属人姓名/公司名称
     */
    @TableField("card_owner")
    private String cardOwner;
    /**
     * 手机号码
     */
    @TableField("phone")
    private String phone;
    /**
     * 产品id
     */
    @TableField("product_id")
    private Integer productId;
    /**
     * 主车牌号
     */
    @TableField("main_plate")
    private String mainPlate;
    /**
     * 车位数
     */
    @TableField("plot_count")
    private Integer plotCount;
    /**
     * 购买数量
     */
    @TableField("count")
    private Integer count;
    /**
     * 月卡所售金额
     */
    @TableField("sale_money")
    private BigDecimal saleMoney;
    /**
     * 支付金额
     */
    @TableField("pay_money")
    private BigDecimal payMoney;
    /**
     * 押金
     */
    @TableField("deposit")
    private BigDecimal deposit;
    /**
     * 支付方式(0 现金，1 银行卡 2：微信 3：支付宝)
     */
    @TableField("pay_method")
    private Integer payMethod;
    /**
     * 支付渠道 1 云平台 2：App 3：公众号
     */
    @TableField("pay_channel")
    private Integer payChannel;
    /**
     * 月卡有效开始日期
     */
    @TableField("start_time")
    private Date startTime;
    /**
     * 月卡有效结束日期
     */
    @TableField("end_time")
    private Date endTime;
    /**
     * 月卡状态 1 生效中 2 待生效 3 已退费 4 已过期 5 冻结 6暂停
     */
    @TableField("card_status")
    private Integer cardStatus;
    /**
     * 操作人
     */
    @TableField("oper_account")
    private String operAccount;
    /**
     * 备注
     */
    @TableField("remark")
    private String remark;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;
    /**
     * 月卡暂停实际开始时间
     */
    @TableField("cardstop_start")
    private Date cardstopStart;
    /**
     * 月卡暂停计划结束时间
     */
    @TableField("cardstop_end")
    private Date cardstopEnd;
    /**
     * 月卡暂停实际结束时间
     */
    @TableField("cardstop_realyend")
    private Date cardstopRealyend;
    /**
     * 状态（0：正常，1：删除，默认0）
     */
    @TableField("delete_status")
    private Integer deleteStatus;
    /**
     * 车主地址
     */
    @TableField("main_address")
    private String mainAddress;
    /**
     * 第三方月卡id
     */
    @TableField("third_month_id")
    private Integer thirdMonthId;
    /**
     * 集团月卡标识 0 月卡，1 多车场月卡 默认0
     */
    @TableField("more_month_type")
    private Byte moreMonthType;
    /**
     * 集团月卡标识id
     */
    @TableField("more_month_id")
    private Integer moreMonthId;
}