package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 短信服务操作记录 实体类
 */
@Data
@TableName("ice_sms_alarm_oper_record")
public class SmsAlarmOperRecord implements Serializable {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 车场编码
     */
    @TableField("park_code")
    private String parkCode;
    /**
     * 操作模块(1-月卡临期提醒;2-特殊车辆提醒开关)
     */
    @TableField("module_type")
    private Integer moduleType;
    /**
     * 操作类型(1-状态变更)
     */
    @TableField("oper_type")
    private Integer operType;
    /**
     * 操作值
     */
    @TableField("oper_val")
    private Integer operVal;
    /**
     * 操作时间
     */
    @TableField("oper_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date operTime;
    /**
     * 操作人
     */
    @TableField("oper_user")
    private String operUser;
}