/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.sdk.sign;

import com.icetech.sdk.sign.IceSignException;
import com.icetech.sdk.sign.SignEncipher;
import com.icetech.sdk.sign.SignEncipherHMAC_MD5;
import com.icetech.sdk.sign.SignEncipherMD5;
import com.icetech.sdk.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class IceSignature {
    private static final Map<String, SignEncipher> signEncipherMap = new HashMap<String, SignEncipher>();

    public static String getSignContent(Map<String, Object> params) {
        StringBuilder content = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            Object value = params.get(key);
            if (!StringUtils.areNotEmpty(key) || !Objects.nonNull(value)) continue;
            content.append(key).append(value);
        }
        return content.toString();
    }

    public static String sign(String content, String secret, String charset, String signType) throws IceSignException {
        SignEncipher signEncipher = signEncipherMap.get(signType);
        if (signEncipher == null) {
            throw new IceSignException("Sign Type is Not Support : signType=" + signType);
        }
        return signEncipher.encrypt(content, secret, charset);
    }

    public static boolean verifySign(Map<String, Object> params, String signKey, String secret, String charset, String signType) throws IceSignException {
        String sign = (String)params.get(signKey);
        if (StringUtils.isEmpty(sign)) {
            throw new IceSignException("Sign is empty");
        }
        params.remove(signKey);
        return sign.equals(IceSignature.sign(IceSignature.getSignContent(params), secret, charset, signType));
    }

    static {
        signEncipherMap.put("md5", new SignEncipherMD5());
        signEncipherMap.put("hmac", new SignEncipherHMAC_MD5());
    }
}

