/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.sdk.request;

import com.icetech.sdk.common.OpenConfig;
import com.icetech.sdk.common.RequestForm;
import com.icetech.sdk.common.RequestMethod;
import com.icetech.sdk.common.UploadFile;
import com.icetech.sdk.response.BaseResponse;
import com.icetech.sdk.util.ClassUtil;
import com.icetech.sdk.util.MapUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseRequest<T extends BaseResponse> {
    private String method;
    private String version;
    private RequestMethod requestMethod = RequestMethod.POST;
    private List<UploadFile> files;
    private Class<T> responseClass = ClassUtil.getSuperClassGenricType(this.getClass(), 0);

    protected abstract String method();

    public BaseRequest() {
        this.method = this.method();
        this.version = this.version();
    }

    protected BaseRequest(String method, String version) {
        this.method = method;
        this.version = version;
    }

    protected String version() {
        return this.version;
    }

    public void addFile(UploadFile file) {
        if (this.files == null) {
            this.files = new ArrayList<UploadFile>();
        }
        this.files.add(file);
    }

    public RequestForm createRequestForm(OpenConfig openConfig) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put(openConfig.getMethodName(), this.method);
        params.put(openConfig.getFormatName(), openConfig.getFormatType());
        params.put(openConfig.getCharsetName(), openConfig.getCharset());
        params.put(openConfig.getSignTypeName(), openConfig.getSignType());
        String timestamp = new SimpleDateFormat(openConfig.getTimestampPattern()).format(new Date());
        params.put(openConfig.getTimestampName(), timestamp);
        String v = this.version == null ? openConfig.getDefaultVersion() : this.version;
        params.put(openConfig.getVersionName(), v);
        HashMap<String, Object> bizContent = new HashMap<String, Object>();
        this.buildBizContent(bizContent);
        params.putAll(bizContent);
        params.entrySet().removeIf(entry -> entry.getValue() == null);
        RequestForm requestForm = new RequestForm(params);
        requestForm.setRequestMethod(this.getRequestMethod());
        requestForm.setCharset(openConfig.getCharset());
        requestForm.setFiles(this.files);
        return requestForm;
    }

    protected void buildBizContent(Map<String, Object> bizContent) {
        bizContent.putAll(MapUtil.objectToMap(this));
    }

    public String getMethod() {
        return this.method;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setFiles(List<UploadFile> files) {
        this.files = files;
    }

    public Class<T> getResponseClass() {
        return this.responseClass;
    }

    public RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(RequestMethod requestMethod) {
        this.requestMethod = requestMethod;
    }
}

