/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.sdk.client;

import com.alibaba.fastjson.JSON;
import com.icetech.sdk.client.OpenHttp;
import com.icetech.sdk.common.IceSdkErrors;
import com.icetech.sdk.common.OpenConfig;
import com.icetech.sdk.common.RequestForm;
import com.icetech.sdk.common.RequestMethod;
import com.icetech.sdk.common.UploadFile;
import com.icetech.sdk.response.BaseResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;

public class OpenRequest {
    private OpenHttp openHttp;

    public OpenRequest(OpenConfig openConfig) {
        this.openHttp = new OpenHttp(openConfig);
    }

    public String request(String url, RequestForm requestForm, Map<String, String> header) {
        try {
            Map<String, Object> form = requestForm.getForm();
            List<UploadFile> files = requestForm.getFiles();
            if (files != null && files.size() > 0) {
                return this.openHttp.requestFile(url, form, header, files);
            }
            RequestMethod requestMethod = requestForm.getRequestMethod();
            if (requestMethod == RequestMethod.GET) {
                String query = this.buildGetQueryString(form, requestForm.getCharset());
                if (query != null && query.length() > 0) {
                    url = url + "?" + query;
                }
                return this.openHttp.get(url, header);
            }
            return this.openHttp.requestJson(url, JSON.toJSONString(form), header);
        }
        catch (IOException e) {
            return this.causeException(e);
        }
    }

    protected String buildGetQueryString(Map<String, Object> params, String charset) throws UnsupportedEncodingException {
        if (params == null || params.size() == 0) {
            return "";
        }
        StringBuilder query = new StringBuilder();
        int i = 0;
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (i++ > 0) {
                query.append("&");
            }
            query.append(name).append("=").append(URLEncoder.encode(value.toString(), charset));
        }
        return query.toString();
    }

    protected String causeException(Exception e) {
        BaseResponse baseResponse = new BaseResponse(){};
        BaseResponse.ErrorResponse result = IceSdkErrors.HTTP_ERROR.getErrorResponse();
        baseResponse.setErrorResponse(result);
        return JSON.toJSONString((Object)baseResponse);
    }
}

