/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.sdk.client;

import com.icetech.sdk.common.OpenConfig;
import com.icetech.sdk.common.RequestMethod;
import com.icetech.sdk.common.UploadFile;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OpenHttp {
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private Map<String, List<Cookie>> cookieStore = new HashMap<String, List<Cookie>>();
    private OkHttpClient httpClient;

    public OpenHttp() {
        this(new OpenConfig());
    }

    public OpenHttp(OpenConfig openConfig) {
        this.initHttpClient(openConfig);
    }

    protected void initHttpClient(OpenConfig openConfig) {
        this.httpClient = new OkHttpClient.Builder().connectTimeout((long)openConfig.getConnectTimeoutSeconds(), TimeUnit.SECONDS).readTimeout((long)openConfig.getReadTimeoutSeconds(), TimeUnit.SECONDS).writeTimeout((long)openConfig.getWriteTimeoutSeconds(), TimeUnit.SECONDS).cookieJar(new CookieJar(){

            public void saveFromResponse(HttpUrl httpUrl, List<Cookie> list) {
                OpenHttp.this.cookieStore.put(httpUrl.host(), list);
            }

            public List<Cookie> loadForRequest(HttpUrl httpUrl) {
                List cookies = (List)OpenHttp.this.cookieStore.get(httpUrl.host());
                return cookies != null ? cookies : new ArrayList();
            }
        }).build();
    }

    public String get(String url, Map<String, String> header) throws IOException {
        Request.Builder builder = new Request.Builder().url(url).get();
        this.addHeader(builder, header);
        Request request = builder.build();
        Response response = this.httpClient.newCall(request).execute();
        return response.body().string();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String requestJson(String url, String json, Map<String, String> header) throws IOException {
        RequestBody body = RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)json);
        Request.Builder requestBuilder = new Request.Builder().url(url).post(body);
        this.addHeader(requestBuilder, header);
        Request request = requestBuilder.build();
        try (Response response = this.httpClient.newCall(request).execute();){
            String string = response.body().string();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String request(String url, Map<String, Object> form, Map<String, String> header, RequestMethod method) throws IOException {
        Request.Builder requestBuilder = OpenHttp.buildRequestBuilder(url, form, method);
        this.addHeader(requestBuilder, header);
        Request request = requestBuilder.build();
        try (Response response = this.httpClient.newCall(request).execute();){
            String string = response.body().string();
            return string;
        }
    }

    public static Request.Builder buildRequestBuilder(String url, Map<String, Object> form, RequestMethod method) {
        switch (method) {
            case GET: {
                return new Request.Builder().url(OpenHttp.buildHttpUrl(url, form)).get();
            }
            case HEAD: {
                return new Request.Builder().url(OpenHttp.buildHttpUrl(url, form)).head();
            }
            case PUT: {
                return new Request.Builder().url(url).put((RequestBody)OpenHttp.buildFormBody(form));
            }
            case DELETE: {
                return new Request.Builder().url(url).delete((RequestBody)OpenHttp.buildFormBody(form));
            }
        }
        return new Request.Builder().url(url).post((RequestBody)OpenHttp.buildFormBody(form));
    }

    public static HttpUrl buildHttpUrl(String url, Map<String, Object> form) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
        for (Map.Entry<String, Object> entry : form.entrySet()) {
            urlBuilder.addQueryParameter(entry.getKey(), entry.getValue().toString());
        }
        return urlBuilder.build();
    }

    public static FormBody buildFormBody(Map<String, Object> form) {
        FormBody.Builder paramBuilder = new FormBody.Builder(StandardCharsets.UTF_8);
        for (Map.Entry<String, Object> entry : form.entrySet()) {
            paramBuilder.add(entry.getKey(), entry.getValue().toString());
        }
        return paramBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String requestFile(String url, Map<String, Object> form, Map<String, String> header, List<UploadFile> files) throws IOException {
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
        bodyBuilder.setType(MultipartBody.FORM);
        for (UploadFile uploadFile : files) {
            bodyBuilder.addFormDataPart(uploadFile.getName(), uploadFile.getFileName(), RequestBody.create(null, (byte[])uploadFile.getFileData()));
        }
        Set<Map.Entry<String, Object>> entrySet = form.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            bodyBuilder.addFormDataPart(entry.getKey(), entry.getValue().toString());
        }
        MultipartBody multipartBody = bodyBuilder.build();
        Request.Builder builder = new Request.Builder().url(url).post((RequestBody)multipartBody);
        this.addHeader(builder, header);
        Request request = builder.build();
        try (Response response = this.httpClient.newCall(request).execute();){
            String string = response.body().string();
            return string;
        }
    }

    private void addHeader(Request.Builder builder, Map<String, String> header) {
        if (header != null) {
            Set<Map.Entry<String, String>> entrySet = header.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                builder.addHeader(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
    }

    public void setCookieStore(Map<String, List<Cookie>> cookieStore) {
        this.cookieStore = cookieStore;
    }

    public void setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

