/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.sdk.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.icetech.sdk.client.OpenRequest;
import com.icetech.sdk.common.DataNameBuilder;
import com.icetech.sdk.common.OpenConfig;
import com.icetech.sdk.common.RequestForm;
import com.icetech.sdk.exception.SdkException;
import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.BaseResponse;
import com.icetech.sdk.response.CommonResponse;
import com.icetech.sdk.sign.IceSignException;
import com.icetech.sdk.sign.IceSignature;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenClient {
    private static final Log log = LogFactory.getLog(OpenClient.class);
    private static final OpenConfig DEFAULT_CONFIG = new OpenConfig();
    private final String url;
    private final String appId;
    private final String secret;
    private final OpenConfig openConfig;
    private final OpenRequest openRequest;
    private final DataNameBuilder dataNameBuilder;

    public OpenClient(String url, String appId, String secret) {
        this(url, appId, secret, DEFAULT_CONFIG);
    }

    public OpenClient(String url, String appId, String secret, OpenConfig openConfig) {
        if (openConfig == null) {
            throw new IllegalArgumentException("openConfig\u4e0d\u80fd\u4e3anull");
        }
        this.url = url;
        this.appId = appId;
        this.secret = secret;
        this.openConfig = openConfig;
        this.openRequest = new OpenRequest(openConfig);
        this.dataNameBuilder = openConfig.getDataNameBuilder();
    }

    public <T extends BaseResponse> T execute(BaseRequest<T> request) {
        return this.execute(request, null);
    }

    public <T extends BaseResponse> T execute(BaseRequest<T> request, String accessToken) {
        String sign;
        RequestForm requestForm = request.createRequestForm(this.openConfig);
        Map<String, Object> form = requestForm.getForm();
        if (accessToken != null) {
            form.put(this.openConfig.getAccessTokenName(), accessToken);
        }
        form.put(this.openConfig.getAppKeyName(), this.appId);
        String content = IceSignature.getSignContent(form);
        try {
            sign = IceSignature.sign(content, this.secret, this.openConfig.getCharset(), this.openConfig.getSignType());
        }
        catch (IceSignException e) {
            throw new SdkException("\u6784\u5efa\u7b7e\u540d\u9519\u8bef", e);
        }
        form.put(this.openConfig.getSignName(), sign);
        String resp = this.doExecute(this.url, requestForm, Collections.emptyMap());
        if (log.isDebugEnabled()) {
            log.debug((Object)("----------- \u8bf7\u6c42\u4fe1\u606f -----------\n\u8bf7\u6c42\u53c2\u6570\uff1a" + IceSignature.getSignContent(form) + "\n\u5f85\u7b7e\u540d\u5185\u5bb9\uff1a" + content + "\n\u7b7e\u540d(sign)\uff1a" + sign + "\n----------- \u8fd4\u56de\u7ed3\u679c -----------\n" + resp));
        }
        return this.parseResponse(resp, request);
    }

    protected String doExecute(String url, RequestForm requestForm, Map<String, String> header) {
        return this.openRequest.request(url, requestForm, header);
    }

    protected <T extends BaseResponse> T parseResponse(String resp, BaseRequest<T> request) {
        String errorResponseName;
        String method = request.getMethod();
        String rootNodeName = this.dataNameBuilder.build(method);
        JSONObject jsonObject = JSON.parseObject((String)resp, (Feature[])new Feature[]{Feature.OrderedField});
        boolean errorResponse = jsonObject.containsKey((Object)(errorResponseName = this.openConfig.getErrorResponseName()));
        if (errorResponse) {
            return (T)((BaseResponse)jsonObject.toJavaObject(request.getResponseClass()));
        }
        JSONObject data = jsonObject.containsKey((Object)rootNodeName) ? jsonObject.getJSONObject(rootNodeName) : jsonObject;
        BaseResponse t = (BaseResponse)data.toJavaObject(request.getResponseClass());
        if (t instanceof CommonResponse) {
            ((CommonResponse)t).setBody(data.toString());
        }
        return (T)t;
    }

    protected String buildJsonNodeData(String body, String rootNodeName, int indexOfRootNode) {
        int signDataStartIndex = indexOfRootNode + rootNodeName.length() + 2;
        int indexOfSign = body.indexOf("\"" + this.openConfig.getSignName() + "\"");
        if (indexOfSign < 0) {
            return null;
        }
        int length = indexOfSign - 1;
        return body.substring(signDataStartIndex, length);
    }
}

