package com.icetech.sdk.sign;


import com.icetech.sdk.util.HexUtil;

import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

/**
 * HMAC_MD5加密
 * @author wgy
 */
public class SignEncipherHMAC_MD5 implements SignEncipher {

    public static final String HMAC_MD5 = "HmacMD5";

    @Override
    public String encrypt(String input, String secret,  String charset) throws IceSignException {
        try {
            SecretKey secretKey = new SecretKeySpec(secret.getBytes(charset), HMAC_MD5);
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            return HexUtil.byte2hex(mac.doFinal(input.getBytes(charset))).toUpperCase();
        } catch (UnsupportedEncodingException | NoSuchAlgorithmException | InvalidKeyException e) {
            throw new IceSignException("HmacMD5 加密失败");
        }
    }
}
