package com.icetech.sdk.sign;


import com.icetech.sdk.util.StringUtils;

import java.util.*;

/**
 * @author runzhi
 */
public class IceSignature {

    private static final Map<String, SignEncipher> signEncipherMap = new HashMap<>();

    static {
        signEncipherMap.put("md5", new SignEncipherMD5());
        signEncipherMap.put("hmac", new SignEncipherHMAC_MD5());
    }


    /**
     * @param params
     * @return
     */
    public static String getSignContent(Map<String, Object> params) {
        StringBuilder content = new StringBuilder();
        List<String> keys = new ArrayList<>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); i++) {
            String key = keys.get(i);
            Object value = params.get(key);
            if (StringUtils.areNotEmpty(key) && Objects.nonNull(value)) {
                content.append(key).append(value);
            }
        }
        return content.toString();
    }

    /**
     * rsa内容签名
     *
     * @param content  加密内容
     * @param secret   密钥
     * @param charset  字符
     * @param signType 加密类型
     * @throws IceSignException
     */
    public static String sign(String content, String secret, String charset, String signType) throws IceSignException {
        SignEncipher signEncipher = signEncipherMap.get(signType);
        if (signEncipher == null) {
            throw new IceSignException("Sign Type is Not Support : signType=" + signType);
        }
        return signEncipher.encrypt(content, secret, charset);
    }
    
    /**
     * Description: 签名校验
     * Version1.0 2022-07-13 by wgy 创建
     * 
     * @param params    参数map
     * @param signKey   签名key
     * @param secret    密钥
     * @param charset   字符
     * @param signType  加密类型
     * @return boolean       
     */
    public static boolean verifySign(Map<String, Object> params, String signKey, String secret, String charset, String signType) throws IceSignException {
        String sign = (String) params.get(signKey);
        if (StringUtils.isEmpty(sign)) {
            throw new IceSignException("Sign is empty");
        }
        params.remove(signKey);
        return sign.equals(sign(getSignContent(params), secret, charset, signType));
    }

}
