package com.icetech.sdk.response.p2c.rule;

import com.icetech.sdk.response.BaseResponse;

import java.io.Serializable;
import java.util.List;

/**
 * Description LedDisplayRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/15 15:59
 */
public class P2cQueryLedDisplayResponse extends BaseResponse {

    /**
     * 停车场编号
     */
    private String parkCode;

    /**
     * 显示屏行数（目前只支持2或4），默认是2
     */
    private Integer ledLineNum;

    /**
     * 月卡剩余多少天进行提示，默认是0,0表示不受限制
     */
    private Integer ledRemainDaysMc;

    /**
     * 月卡过期小于多少天进行提示，默认是0,0表示不受限制
     */
    private Integer ledExpireDaysMc;

    /**
     * 黑名单车辆信息是否提示，0提示，1不提示，默认为0
     */
    private Integer ledBlackCar;

    /**
     * 恢复空闲显示时长，单位是秒，默认是90s
     */
    private Integer ledRestoreDefaultTime;

    /**
     * 二维码是否显示，0不显示，1显示，默认为0
     */
    private Integer ledQrcodeRule;

    /**
     * 限行类型，0是尾号限行，1是单双号限行
     */
    private Integer limitType;

    /**
     * 周一限行信息，尾号限行必传 如4和9
     */
    private String limitDriveNum1;

    /**
     * 周二限行信息，尾号限行必传
     */
    private String limitDriveNum2;

    /**
     * 周三限行信息，尾号限行必传
     */
    private String limitDriveNum3;

    /**
     * 周四限行信息，尾号限行必传
     */
    private String limitDriveNum4;

    /**
     * 周五限行信息，尾号限行必传
     */
    private String limitDriveNum5;

    /**
     * 屏显配置
     */
    private List<LedConfig> ledConfig;

    /**
     * 屏显特殊配置
     */
    private LedSpecial ledSpecial;

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    /**
     * Gets led line num.
     *
     * @return the led line num
     */
    public Integer getLedLineNum() {
        return ledLineNum;
    }

    /**
     * Sets led line num.
     *
     * @param ledLineNum the led line num
     */
    public void setLedLineNum(Integer ledLineNum) {
        this.ledLineNum = ledLineNum;
    }

    /**
     * Gets led remain days mc.
     *
     * @return the led remain days mc
     */
    public Integer getLedRemainDaysMc() {
        return ledRemainDaysMc;
    }

    /**
     * Sets led remain days mc.
     *
     * @param ledRemainDaysMc the led remain days mc
     */
    public void setLedRemainDaysMc(Integer ledRemainDaysMc) {
        this.ledRemainDaysMc = ledRemainDaysMc;
    }

    /**
     * Gets led expire days mc.
     *
     * @return the led expire days mc
     */
    public Integer getLedExpireDaysMc() {
        return ledExpireDaysMc;
    }

    /**
     * Sets led expire days mc.
     *
     * @param ledExpireDaysMc the led expire days mc
     */
    public void setLedExpireDaysMc(Integer ledExpireDaysMc) {
        this.ledExpireDaysMc = ledExpireDaysMc;
    }

    /**
     * Gets led black car.
     *
     * @return the led black car
     */
    public Integer getLedBlackCar() {
        return ledBlackCar;
    }

    /**
     * Sets led black car.
     *
     * @param ledBlackCar the led black car
     */
    public void setLedBlackCar(Integer ledBlackCar) {
        this.ledBlackCar = ledBlackCar;
    }

    /**
     * Gets led restore default time.
     *
     * @return the led restore default time
     */
    public Integer getLedRestoreDefaultTime() {
        return ledRestoreDefaultTime;
    }

    /**
     * Sets led restore default time.
     *
     * @param ledRestoreDefaultTime the led restore default time
     */
    public void setLedRestoreDefaultTime(Integer ledRestoreDefaultTime) {
        this.ledRestoreDefaultTime = ledRestoreDefaultTime;
    }

    /**
     * Gets led qrcode rule.
     *
     * @return the led qrcode rule
     */
    public Integer getLedQrcodeRule() {
        return ledQrcodeRule;
    }

    /**
     * Sets led qrcode rule.
     *
     * @param ledQrcodeRule the led qrcode rule
     */
    public void setLedQrcodeRule(Integer ledQrcodeRule) {
        this.ledQrcodeRule = ledQrcodeRule;
    }

    /**
     * Gets limit type.
     *
     * @return the limit type
     */
    public Integer getLimitType() {
        return limitType;
    }

    /**
     * Sets limit type.
     *
     * @param limitType the limit type
     */
    public void setLimitType(Integer limitType) {
        this.limitType = limitType;
    }

    /**
     * Gets limit drive num 1.
     *
     * @return the limit drive num 1
     */
    public String getLimitDriveNum1() {
        return limitDriveNum1;
    }

    /**
     * Sets limit drive num 1.
     *
     * @param limitDriveNum1 the limit drive num 1
     */
    public void setLimitDriveNum1(String limitDriveNum1) {
        this.limitDriveNum1 = limitDriveNum1;
    }

    /**
     * Gets limit drive num 2.
     *
     * @return the limit drive num 2
     */
    public String getLimitDriveNum2() {
        return limitDriveNum2;
    }

    /**
     * Sets limit drive num 2.
     *
     * @param limitDriveNum2 the limit drive num 2
     */
    public void setLimitDriveNum2(String limitDriveNum2) {
        this.limitDriveNum2 = limitDriveNum2;
    }

    /**
     * Gets limit drive num 3.
     *
     * @return the limit drive num 3
     */
    public String getLimitDriveNum3() {
        return limitDriveNum3;
    }

    /**
     * Sets limit drive num 3.
     *
     * @param limitDriveNum3 the limit drive num 3
     */
    public void setLimitDriveNum3(String limitDriveNum3) {
        this.limitDriveNum3 = limitDriveNum3;
    }

    /**
     * Gets limit drive num 4.
     *
     * @return the limit drive num 4
     */
    public String getLimitDriveNum4() {
        return limitDriveNum4;
    }

    /**
     * Sets limit drive num 4.
     *
     * @param limitDriveNum4 the limit drive num 4
     */
    public void setLimitDriveNum4(String limitDriveNum4) {
        this.limitDriveNum4 = limitDriveNum4;
    }

    /**
     * Gets limit drive num 5.
     *
     * @return the limit drive num 5
     */
    public String getLimitDriveNum5() {
        return limitDriveNum5;
    }

    /**
     * Sets limit drive num 5.
     *
     * @param limitDriveNum5 the limit drive num 5
     */
    public void setLimitDriveNum5(String limitDriveNum5) {
        this.limitDriveNum5 = limitDriveNum5;
    }

    /**
     * Gets led config.
     *
     * @return the led config
     */
    public List<LedConfig> getLedConfig() {
        return ledConfig;
    }

    /**
     * Sets led config.
     *
     * @param ledConfig the led config
     */
    public void setLedConfig(List<LedConfig> ledConfig) {
        this.ledConfig = ledConfig;
    }

    /**
     * Gets led special.
     *
     * @return the led special
     */
    public LedSpecial getLedSpecial() {
        return ledSpecial;
    }

    /**
     * Sets led special.
     *
     * @param ledSpecial the led special
     */
    public void setLedSpecial(LedSpecial ledSpecial) {
        this.ledSpecial = ledSpecial;
    }

    /**
     * The type Led config.
     */
    public static class LedConfig implements Serializable {

        /**
         * 显示类型 1：入口空闲显示、2：出口空闲显示、3：入场显示、4：出场显示
         */
        private Integer displayType;

        /**
         * 显示在第几行，1：第一行、2：第二行、3：第三行、4：第四行，目前最多有4行
         */
        private Integer rowNum;

        /**
         * 显示颜色1：红色，2：绿色，3：黄色，4：蓝色（只有LCD屏有蓝色），LED屏默认第一、三行是1（红色），二、四行时2（绿色）,LCD屏默认第一行蓝色，第二行绿色，第三行红色
         */
        private Integer ledColor;

        /**
         * 动态内容编号和显示序号，多个之间用”+”符号链接，编号和序号之间用”_”符号链接，动态内容有：1：当前时间、2：今日限号、3：剩余车位、4：车牌号、5：车辆类型、6：月卡剩余天数、7：停车时长、8：入场提示、9：缴费/出场提示、10：需支付金额、11" +
         *                 "：停车场名称、12：储值卡余额（比如：”4_1+5_3”,动态内容需要显示车牌号和车辆类型，车牌号排第一显示，车辆类型排第三显示）
         */
        private String dynamicContent;

        /**
         * 自定义内容和显示序号，多个之间用”+”符号链接，内容和序号之间用”_”符号链接(比如”一路平安_2+注意安全_4”,自定义内容中一路平安排第二显示，注意安全排第四显示)
         */
        private String customContent;

        /**
         * Gets display type.
         *
         * @return the display type
         */
        public Integer getDisplayType() {
            return displayType;
        }

        /**
         * Sets display type.
         *
         * @param displayType the display type
         */
        public void setDisplayType(Integer displayType) {
            this.displayType = displayType;
        }

        /**
         * Gets row num.
         *
         * @return the row num
         */
        public Integer getRowNum() {
            return rowNum;
        }

        /**
         * Sets row num.
         *
         * @param rowNum the row num
         */
        public void setRowNum(Integer rowNum) {
            this.rowNum = rowNum;
        }

        /**
         * Gets led color.
         *
         * @return the led color
         */
        public Integer getLedColor() {
            return ledColor;
        }

        /**
         * Sets led color.
         *
         * @param ledColor the led color
         */
        public void setLedColor(Integer ledColor) {
            this.ledColor = ledColor;
        }

        /**
         * Gets dynamic content.
         *
         * @return the dynamic content
         */
        public String getDynamicContent() {
            return dynamicContent;
        }

        /**
         * Sets dynamic content.
         *
         * @param dynamicContent the dynamic content
         */
        public void setDynamicContent(String dynamicContent) {
            this.dynamicContent = dynamicContent;
        }

        /**
         * Gets custom content.
         *
         * @return the custom content
         */
        public String getCustomContent() {
            return customContent;
        }

        /**
         * Sets custom content.
         *
         * @param customContent the custom content
         */
        public void setCustomContent(String customContent) {
            this.customContent = customContent;
        }
    }

    /**
     * The type Led special.
     */
    public static class LedSpecial implements Serializable {

        /**
         * 入场临时车/特殊车辆，默认：欢迎光临
         */
        private String enterTmpSpecial;

        /**
         * 入场月卡车/内部车，默认：欢迎光临
         */
        private String enterMonthVip;

        /**
         * 入场临时车禁止入场，默认：非月卡车禁止入内
         */
        private String enterNotAllowTmpRun;

        /**
         * 入场多卡多车情况，车位被占用提示，默认：车位已占
         */
        private String enterMultiParkCar;

        /**
         * 入场黑名单提示，默认：禁止通行
         */
        private String enterBlackCar;

        /**
         * 入场月卡过期提示，默认：月卡车已过期
         */
        private String enterMonthExpire;

        /**
         * 入场没有空车位提示信息，默认：车位已满 禁止入内
         */
        private String enterNoParkingSpace;

        /**
         * 无牌车入场提示，默认：请扫码入场
         */
        private String enterNotAllowNocarRun;

        /**
         * 出场缴费提示，默认：请扫码缴费
         */
        private String exitPay;

        /**
         * 出场开闸提示，默认：一路平安
         */
        private String exitOpenGate;

        /**
         * 出场无在场记录，默认：无入场信息/请呼叫管理员
         */
        private String exitNoEnterinfo;

        /**
         * 无牌车出场，默认：请扫码出场
         */
        private String exitNoCarplate;

        /**
         * Gets enter tmp special.
         *
         * @return the enter tmp special
         */
        public String getEnterTmpSpecial() {
            return enterTmpSpecial;
        }

        /**
         * Sets enter tmp special.
         *
         * @param enterTmpSpecial the enter tmp special
         */
        public void setEnterTmpSpecial(String enterTmpSpecial) {
            this.enterTmpSpecial = enterTmpSpecial;
        }

        /**
         * Gets enter month vip.
         *
         * @return the enter month vip
         */
        public String getEnterMonthVip() {
            return enterMonthVip;
        }

        /**
         * Sets enter month vip.
         *
         * @param enterMonthVip the enter month vip
         */
        public void setEnterMonthVip(String enterMonthVip) {
            this.enterMonthVip = enterMonthVip;
        }

        /**
         * Gets enter not allow tmp run.
         *
         * @return the enter not allow tmp run
         */
        public String getEnterNotAllowTmpRun() {
            return enterNotAllowTmpRun;
        }

        /**
         * Sets enter not allow tmp run.
         *
         * @param enterNotAllowTmpRun the enter not allow tmp run
         */
        public void setEnterNotAllowTmpRun(String enterNotAllowTmpRun) {
            this.enterNotAllowTmpRun = enterNotAllowTmpRun;
        }

        /**
         * Gets enter multi park car.
         *
         * @return the enter multi park car
         */
        public String getEnterMultiParkCar() {
            return enterMultiParkCar;
        }

        /**
         * Sets enter multi park car.
         *
         * @param enterMultiParkCar the enter multi park car
         */
        public void setEnterMultiParkCar(String enterMultiParkCar) {
            this.enterMultiParkCar = enterMultiParkCar;
        }

        /**
         * Gets enter black car.
         *
         * @return the enter black car
         */
        public String getEnterBlackCar() {
            return enterBlackCar;
        }

        /**
         * Sets enter black car.
         *
         * @param enterBlackCar the enter black car
         */
        public void setEnterBlackCar(String enterBlackCar) {
            this.enterBlackCar = enterBlackCar;
        }

        /**
         * Gets enter month expire.
         *
         * @return the enter month expire
         */
        public String getEnterMonthExpire() {
            return enterMonthExpire;
        }

        /**
         * Sets enter month expire.
         *
         * @param enterMonthExpire the enter month expire
         */
        public void setEnterMonthExpire(String enterMonthExpire) {
            this.enterMonthExpire = enterMonthExpire;
        }

        /**
         * Gets enter no parking space.
         *
         * @return the enter no parking space
         */
        public String getEnterNoParkingSpace() {
            return enterNoParkingSpace;
        }

        /**
         * Sets enter no parking space.
         *
         * @param enterNoParkingSpace the enter no parking space
         */
        public void setEnterNoParkingSpace(String enterNoParkingSpace) {
            this.enterNoParkingSpace = enterNoParkingSpace;
        }

        /**
         * Gets enter not allow nocar run.
         *
         * @return the enter not allow nocar run
         */
        public String getEnterNotAllowNocarRun() {
            return enterNotAllowNocarRun;
        }

        /**
         * Sets enter not allow nocar run.
         *
         * @param enterNotAllowNocarRun the enter not allow nocar run
         */
        public void setEnterNotAllowNocarRun(String enterNotAllowNocarRun) {
            this.enterNotAllowNocarRun = enterNotAllowNocarRun;
        }

        /**
         * Gets exit pay.
         *
         * @return the exit pay
         */
        public String getExitPay() {
            return exitPay;
        }

        /**
         * Sets exit pay.
         *
         * @param exitPay the exit pay
         */
        public void setExitPay(String exitPay) {
            this.exitPay = exitPay;
        }

        /**
         * Gets exit open gate.
         *
         * @return the exit open gate
         */
        public String getExitOpenGate() {
            return exitOpenGate;
        }

        /**
         * Sets exit open gate.
         *
         * @param exitOpenGate the exit open gate
         */
        public void setExitOpenGate(String exitOpenGate) {
            this.exitOpenGate = exitOpenGate;
        }

        /**
         * Gets exit no enterinfo.
         *
         * @return the exit no enterinfo
         */
        public String getExitNoEnterinfo() {
            return exitNoEnterinfo;
        }

        /**
         * Sets exit no enterinfo.
         *
         * @param exitNoEnterinfo the exit no enterinfo
         */
        public void setExitNoEnterinfo(String exitNoEnterinfo) {
            this.exitNoEnterinfo = exitNoEnterinfo;
        }

        /**
         * Gets exit no carplate.
         *
         * @return the exit no carplate
         */
        public String getExitNoCarplate() {
            return exitNoCarplate;
        }

        /**
         * Sets exit no carplate.
         *
         * @param exitNoCarplate the exit no carplate
         */
        public void setExitNoCarplate(String exitNoCarplate) {
            this.exitNoCarplate = exitNoCarplate;
        }
    }

}
