package com.icetech.sdk.response.p2c.rule;

import com.icetech.sdk.response.BaseResponse;

import java.io.Serializable;
import java.util.List;

/**
 * Description P2cChargeRuleListResponse
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/15 18:08
 */
public class P2cChargeRuleListResponse extends BaseResponse {


    /**
     * 总记录数
     */
    private Long total;

    /**
     * 总页数
     */
    private String totalPage;

    /**
     * 返回数据结果
     */
    private List<ChargeRuleListItem> rows;

    public Long getTotal() {
        return total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public String getTotalPage() {
        return totalPage;
    }

    public void setTotalPage(String totalPage) {
        this.totalPage = totalPage;
    }

    public List<ChargeRuleListItem> getRows() {
        return rows;
    }

    public void setRows(List<ChargeRuleListItem> rows) {
        this.rows = rows;
    }

    public static class ChargeRuleListItem implements Serializable{
        /**
         * 计费规则编号
         */
        private String billtypecode;

        /**
         * 计费规则名称
         */
        private String billtypename;

        /**
         * 计费规则类型 1、通用自然天 2、白天夜间收费 3、24小时计费
         */
        private Integer billtype;

        /**
         * 是否默认计费规则，0：否，1：是，车辆计费时使用默认计费规则
         */
        private Integer isDefault;

        /**
         * 操作时间（unix时间戳）
         */
        private Long operTime;

        public String getBilltypecode() {
            return billtypecode;
        }

        public void setBilltypecode(String billtypecode) {
            this.billtypecode = billtypecode;
        }

        public String getBilltypename() {
            return billtypename;
        }

        public void setBilltypename(String billtypename) {
            this.billtypename = billtypename;
        }

        public Integer getBilltype() {
            return billtype;
        }

        public void setBilltype(Integer billtype) {
            this.billtype = billtype;
        }

        public Integer getIsDefault() {
            return isDefault;
        }

        public void setIsDefault(Integer isDefault) {
            this.isDefault = isDefault;
        }

        public Long getOperTime() {
            return operTime;
        }

        public void setOperTime(Long operTime) {
            this.operTime = operTime;
        }
    }

}
