package com.icetech.sdk.response.p2c.pay;

import com.icetech.sdk.response.BaseResponse;

import java.math.BigDecimal;
import java.util.List;

/**
 * 订单查询响应
 *
 * @author wangzhiwei
 */
public class P2cQueryPayResultResponse extends BaseResponse {

    /**
     * 记录列表
     */
    private List<P2cQueryPayResultItem> items;

    /**
     * Gets items.
     *
     * @return the items
     */
    public List<P2cQueryPayResultItem> getItems() {
        return items;
    }

    /**
     * Sets items.
     *
     * @param items the items
     */
    public void setItems(List<P2cQueryPayResultItem> items) {
        this.items = items;
    }

    /**
     * The type P 2 c query pay result item.
     */
    public static class P2cQueryPayResultItem {
        /**
         * 停车场编号
         */
        private String parkCode;

        /**
         * 停车场名称
         */
        private String parkName;

        /**
         * 订单号，确保订单号在此车场内的唯一性
         */
        private String orderNum;

        /**
         * 交易流水号
         */
        private String tradeNo;

        /**
         * 支付时间（unix时间戳 10位）
         */
        private Long payTime;

        /**
         * 总支付金额
         */
        private BigDecimal totalPrice;

        /**
         * 已支付金额
         */
        private BigDecimal paidPrice;

        /**
         * 优惠金额
         */
        private BigDecimal discountPrice;

        /**
         * 支付渠道，详情查看数据定义部分
         */
        private Integer payChannel;

        /**
         * 支付方式，详情查看数据定义部分
         */
        private Integer payWay;

        /**
         * 缴费的通道编号，不传时为场内支付
         */
        private String channelCode;

        /**
         * Gets park code.
         *
         * @return the park code
         */
        public String getParkCode() {
            return parkCode;
        }

        /**
         * Sets park code.
         *
         * @param parkCode the park code
         */
        public void setParkCode(String parkCode) {
            this.parkCode = parkCode;
        }

        /**
         * Gets park name.
         *
         * @return the park name
         */
        public String getParkName() {
            return parkName;
        }

        /**
         * Sets park name.
         *
         * @param parkName the park name
         */
        public void setParkName(String parkName) {
            this.parkName = parkName;
        }

        /**
         * Gets order num.
         *
         * @return the order num
         */
        public String getOrderNum() {
            return orderNum;
        }

        /**
         * Sets order num.
         *
         * @param orderNum the order num
         */
        public void setOrderNum(String orderNum) {
            this.orderNum = orderNum;
        }

        /**
         * Gets trade no.
         *
         * @return the trade no
         */
        public String getTradeNo() {
            return tradeNo;
        }

        /**
         * Sets trade no.
         *
         * @param tradeNo the trade no
         */
        public void setTradeNo(String tradeNo) {
            this.tradeNo = tradeNo;
        }

        /**
         * Gets pay time.
         *
         * @return the pay time
         */
        public Long getPayTime() {
            return payTime;
        }

        /**
         * Sets pay time.
         *
         * @param payTime the pay time
         */
        public void setPayTime(Long payTime) {
            this.payTime = payTime;
        }

        /**
         * Gets total price.
         *
         * @return the total price
         */
        public BigDecimal getTotalPrice() {
            return totalPrice;
        }

        /**
         * Sets total price.
         *
         * @param totalPrice the total price
         */
        public void setTotalPrice(BigDecimal totalPrice) {
            this.totalPrice = totalPrice;
        }

        /**
         * Gets paid price.
         *
         * @return the paid price
         */
        public BigDecimal getPaidPrice() {
            return paidPrice;
        }

        /**
         * Sets paid price.
         *
         * @param paidPrice the paid price
         */
        public void setPaidPrice(BigDecimal paidPrice) {
            this.paidPrice = paidPrice;
        }

        /**
         * Gets discount price.
         *
         * @return the discount price
         */
        public BigDecimal getDiscountPrice() {
            return discountPrice;
        }

        /**
         * Sets discount price.
         *
         * @param discountPrice the discount price
         */
        public void setDiscountPrice(BigDecimal discountPrice) {
            this.discountPrice = discountPrice;
        }

        /**
         * Gets pay channel.
         *
         * @return the pay channel
         */
        public Integer getPayChannel() {
            return payChannel;
        }

        /**
         * Sets pay channel.
         *
         * @param payChannel the pay channel
         */
        public void setPayChannel(Integer payChannel) {
            this.payChannel = payChannel;
        }

        /**
         * Gets pay way.
         *
         * @return the pay way
         */
        public Integer getPayWay() {
            return payWay;
        }

        /**
         * Sets pay way.
         *
         * @param payWay the pay way
         */
        public void setPayWay(Integer payWay) {
            this.payWay = payWay;
        }

        /**
         * Gets channel code.
         *
         * @return the channel code
         */
        public String getChannelCode() {
            return channelCode;
        }

        /**
         * Sets channel code.
         *
         * @param channelCode the channel code
         */
        public void setChannelCode(String channelCode) {
            this.channelCode = channelCode;
        }
    }
}
