package com.icetech.sdk.response.p2c.pay;

import com.icetech.sdk.response.BaseResponse;

/**
 * The type P 2 c query fee response.
 */
public class P2cQueryFeeResponse extends BaseResponse {

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 车场名称
     */
    private String parkName;

    /**
     * 车辆入场时间[unix时间戳 10位]
     */
    private Long enterTime;

    /**
     * 车牌号 / 无牌车没有车牌传递临时车牌号
     */
    private String plateNum;

    /**
     * 交易流水号
     */
    private String tradeNo;

    /**
     * 车型
     */
    private Integer carType;

    /**
     * 总应收 本车辆从入场到当前时刻的总费用
     */
    private Double totalPrice;

    /**
     * 实收 (已经缴费金额)
     */
    private Double paidPrice;

    /**
     * 总优惠
     */
    private Double discountPrice;

    /**
     * 需支付金额
     */
    private Double needPayPrice;

    /**
     * 停车时长（秒）
     */
    private Integer parkTime;

    /**
     * 第三方抵扣金额总和
     */
    private Double outDiscAmount;

    /**
     * 停车云平台抵扣金额总和
     */
    private Double inDiscAmount;

    /**
     * 交费后预留免费时长，单位分钟
     */
    private Integer freeAfterPay;

    /**
     * Gets order num.
     *
     * @return the order num
     */
    public String getOrderNum() {
        return orderNum;
    }

    /**
     * Sets order num.
     *
     * @param orderNum the order num
     */
    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    /**
     * Gets park name.
     *
     * @return the park name
     */
    public String getParkName() {
        return parkName;
    }

    /**
     * Sets park name.
     *
     * @param parkName the park name
     */
    public void setParkName(String parkName) {
        this.parkName = parkName;
    }

    /**
     * Gets enter time.
     *
     * @return the enter time
     */
    public Long getEnterTime() {
        return enterTime;
    }

    /**
     * Sets enter time.
     *
     * @param enterTime the enter time
     */
    public void setEnterTime(Long enterTime) {
        this.enterTime = enterTime;
    }

    /**
     * Gets plate num.
     *
     * @return the plate num
     */
    public String getPlateNum() {
        return plateNum;
    }

    /**
     * Sets plate num.
     *
     * @param plateNum the plate num
     */
    public void setPlateNum(String plateNum) {
        this.plateNum = plateNum;
    }

    /**
     * Gets trade no.
     *
     * @return the trade no
     */
    public String getTradeNo() {
        return tradeNo;
    }

    /**
     * Sets trade no.
     *
     * @param tradeNo the trade no
     */
    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    /**
     * Gets car type.
     *
     * @return the car type
     */
    public Integer getCarType() {
        return carType;
    }

    /**
     * Sets car type.
     *
     * @param carType the car type
     */
    public void setCarType(Integer carType) {
        this.carType = carType;
    }

    /**
     * Gets total price.
     *
     * @return the total price
     */
    public Double getTotalPrice() {
        return totalPrice;
    }

    /**
     * Sets total price.
     *
     * @param totalPrice the total price
     */
    public void setTotalPrice(Double totalPrice) {
        this.totalPrice = totalPrice;
    }

    /**
     * Gets paid price.
     *
     * @return the paid price
     */
    public Double getPaidPrice() {
        return paidPrice;
    }

    /**
     * Sets paid price.
     *
     * @param paidPrice the paid price
     */
    public void setPaidPrice(Double paidPrice) {
        this.paidPrice = paidPrice;
    }

    /**
     * Gets discount price.
     *
     * @return the discount price
     */
    public Double getDiscountPrice() {
        return discountPrice;
    }

    /**
     * Sets discount price.
     *
     * @param discountPrice the discount price
     */
    public void setDiscountPrice(Double discountPrice) {
        this.discountPrice = discountPrice;
    }

    /**
     * Gets need pay price.
     *
     * @return the need pay price
     */
    public Double getNeedPayPrice() {
        return needPayPrice;
    }

    /**
     * Sets need pay price.
     *
     * @param needPayPrice the need pay price
     */
    public void setNeedPayPrice(Double needPayPrice) {
        this.needPayPrice = needPayPrice;
    }

    /**
     * Gets park time.
     *
     * @return the park time
     */
    public Integer getParkTime() {
        return parkTime;
    }

    /**
     * Sets park time.
     *
     * @param parkTime the park time
     */
    public void setParkTime(Integer parkTime) {
        this.parkTime = parkTime;
    }

    /**
     * Gets out disc amount.
     *
     * @return the out disc amount
     */
    public Double getOutDiscAmount() {
        return outDiscAmount;
    }

    /**
     * Sets out disc amount.
     *
     * @param outDiscAmount the out disc amount
     */
    public void setOutDiscAmount(Double outDiscAmount) {
        this.outDiscAmount = outDiscAmount;
    }

    /**
     * Gets in disc amount.
     *
     * @return the in disc amount
     */
    public Double getInDiscAmount() {
        return inDiscAmount;
    }

    /**
     * Sets in disc amount.
     *
     * @param inDiscAmount the in disc amount
     */
    public void setInDiscAmount(Double inDiscAmount) {
        this.inDiscAmount = inDiscAmount;
    }

    /**
     * Gets free after pay.
     *
     * @return the free after pay
     */
    public Integer getFreeAfterPay() {
        return freeAfterPay;
    }

    /**
     * Sets free after pay.
     *
     * @param freeAfterPay the free after pay
     */
    public void setFreeAfterPay(Integer freeAfterPay) {
        this.freeAfterPay = freeAfterPay;
    }
}
