package com.icetech.sdk.response.p2c.pay;

import com.icetech.sdk.response.BaseResponse;

import java.util.List;

/**
 * The type P 2 c query exit record response.
 */
public class P2cQueryExitRecordResponse extends BaseResponse {

    /**
     * 记录列表
     */
    private List<P2cQueryExitRecord> items;

    /**
     * Gets items.
     *
     * @return the items
     */
    public List<P2cQueryExitRecord> getItems() {
        return items;
    }

    /**
     * Sets items.
     *
     * @param items the items
     */
    public void setItems(List<P2cQueryExitRecord> items) {
        this.items = items;
    }

    /**
     * The type P 2 c query exit record.
     */
    public static class P2cQueryExitRecord {
        /**
         * 停车场编号
         */
        private String parkCode;

        /**
         * 停车场名称
         */
        private String parkName;

        /**
         * 订单号，确保订单号在此车场内的唯一性
         */
        private String orderNum;

        /**
         * 车牌号
         */
        private String plateNum;

        /**
         * 入口名称
         */
        private String channelName;

        /**
         * 出场时间（unix时间戳 10位）
         */
        private Long exitTime;

        /**
         * 停车时长（秒）
         */
        private Long parkTime;

        /**
         * 车辆类型，详情查看数据定义部分
         */
        private Integer type;

        /**
         * 车型，详情查看数据定义部分
         */
        private Integer carType;

        /**
         * 总金额，从入场到出场产生的应收总费用
         */
        private Double totalAmount;

        /**
         * 实收总金额，从入场到出场产生的实收总费用
         */
        private Double paidAmount;

        /**
         * 优惠总金额，从入场到出场产生的优惠总费用
         */
        private Double discountAmount;

        /**
         * 离场图片URL，注意：url有效期为30分钟
         */
        private String imgUrl;

        /**
         * 车牌颜色
         */
        private String plateColor;

        /**
         * 是否异常离场
         */
        private Integer isExceptionExit;

        /**
         * Gets park code.
         *
         * @return the park code
         */
        public String getParkCode() {
            return parkCode;
        }

        /**
         * Sets park code.
         *
         * @param parkCode the park code
         */
        public void setParkCode(String parkCode) {
            this.parkCode = parkCode;
        }

        /**
         * Gets park name.
         *
         * @return the park name
         */
        public String getParkName() {
            return parkName;
        }

        /**
         * Sets park name.
         *
         * @param parkName the park name
         */
        public void setParkName(String parkName) {
            this.parkName = parkName;
        }

        /**
         * Gets order num.
         *
         * @return the order num
         */
        public String getOrderNum() {
            return orderNum;
        }

        /**
         * Sets order num.
         *
         * @param orderNum the order num
         */
        public void setOrderNum(String orderNum) {
            this.orderNum = orderNum;
        }

        /**
         * Gets plate num.
         *
         * @return the plate num
         */
        public String getPlateNum() {
            return plateNum;
        }

        /**
         * Sets plate num.
         *
         * @param plateNum the plate num
         */
        public void setPlateNum(String plateNum) {
            this.plateNum = plateNum;
        }

        /**
         * Gets channel name.
         *
         * @return the channel name
         */
        public String getChannelName() {
            return channelName;
        }

        /**
         * Sets channel name.
         *
         * @param channelName the channel name
         */
        public void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        /**
         * Gets exit time.
         *
         * @return the exit time
         */
        public Long getExitTime() {
            return exitTime;
        }

        /**
         * Sets exit time.
         *
         * @param exitTime the exit time
         */
        public void setExitTime(Long exitTime) {
            this.exitTime = exitTime;
        }

        /**
         * Gets park time.
         *
         * @return the park time
         */
        public Long getParkTime() {
            return parkTime;
        }

        /**
         * Sets park time.
         *
         * @param parkTime the park time
         */
        public void setParkTime(Long parkTime) {
            this.parkTime = parkTime;
        }

        /**
         * Gets type.
         *
         * @return the type
         */
        public Integer getType() {
            return type;
        }

        /**
         * Sets type.
         *
         * @param type the type
         */
        public void setType(Integer type) {
            this.type = type;
        }

        /**
         * Gets car type.
         *
         * @return the car type
         */
        public Integer getCarType() {
            return carType;
        }

        /**
         * Sets car type.
         *
         * @param carType the car type
         */
        public void setCarType(Integer carType) {
            this.carType = carType;
        }

        /**
         * Gets total amount.
         *
         * @return the total amount
         */
        public Double getTotalAmount() {
            return totalAmount;
        }

        /**
         * Sets total amount.
         *
         * @param totalAmount the total amount
         */
        public void setTotalAmount(Double totalAmount) {
            this.totalAmount = totalAmount;
        }

        /**
         * Gets paid amount.
         *
         * @return the paid amount
         */
        public Double getPaidAmount() {
            return paidAmount;
        }

        /**
         * Sets paid amount.
         *
         * @param paidAmount the paid amount
         */
        public void setPaidAmount(Double paidAmount) {
            this.paidAmount = paidAmount;
        }

        /**
         * Gets discount amount.
         *
         * @return the discount amount
         */
        public Double getDiscountAmount() {
            return discountAmount;
        }

        /**
         * Sets discount amount.
         *
         * @param discountAmount the discount amount
         */
        public void setDiscountAmount(Double discountAmount) {
            this.discountAmount = discountAmount;
        }

        /**
         * Gets img url.
         *
         * @return the img url
         */
        public String getImgUrl() {
            return imgUrl;
        }

        /**
         * Sets img url.
         *
         * @param imgUrl the img url
         */
        public void setImgUrl(String imgUrl) {
            this.imgUrl = imgUrl;
        }

        /**
         * Gets plate color.
         *
         * @return the plate color
         */
        public String getPlateColor() {
            return plateColor;
        }

        /**
         * Sets plate color.
         *
         * @param plateColor the plate color
         */
        public void setPlateColor(String plateColor) {
            this.plateColor = plateColor;
        }

        /**
         * Gets is exception exit.
         *
         * @return the is exception exit
         */
        public Integer getIsExceptionExit() {
            return isExceptionExit;
        }

        /**
         * Sets is exception exit.
         *
         * @param isExceptionExit the is exception exit
         */
        public void setIsExceptionExit(Integer isExceptionExit) {
            this.isExceptionExit = isExceptionExit;
        }
    }
    
}
