package com.icetech.sdk.response.p2c.pay;

import com.icetech.sdk.response.BaseResponse;

import java.util.List;

/**
 * The type P 2 c query enter record response.
 */
public class P2cQueryEnterRecordResponse extends BaseResponse {

    /**
     * 城市列表
     */
    private List<P2cQueryEnterRecordItem> items;

    /**
     * Gets items.
     *
     * @return the items
     */
    public List<P2cQueryEnterRecordItem> getItems() {
        return items;
    }

    /**
     * Sets items.
     *
     * @param items the items
     */
    public void setItems(List<P2cQueryEnterRecordItem> items) {
        this.items = items;
    }

    /**
     * The type P 2 c query enter record item.
     */
    public static class P2cQueryEnterRecordItem {
        /**
         * 停车场编号
         */
        private String parkCode;

        /**
         * 停车场名称
         */
        private String parkName;

        /**
         * 订单号，确保订单号在此车场内的唯一性
         */
        private String orderNum;

        /**
         * 车牌号
         */
        private String plateNum;

        /**
         * 入口名称
         */
        private String channelName;

        /**
         * 车辆类型，详情查看数据定义部分
         */
        private Integer type;

        /**
         * 车型，详情查看数据定义部分
         */
        private Integer carType;

        /**
         * 入场图片URL，注意：url有效期为30分钟
         */
        private String imgUrl;

        /**
         * 无入场记录标识，0：否，1：是
         */
        private Integer noneEnterFlag = 0;

        /**
         * 车牌颜色
         */
        private String plateColor;

        /**
         * 进场时间（unix时间戳 10位）
         */
        private Long enterTime;
        /**
         * 入场方式：1车牌识别入场，2遥控器抬杆入场，3无牌车扫码入场，4软件人工入场
         */
        private Integer enterWay;

        /**
         * Gets park code.
         *
         * @return the park code
         */
        public String getParkCode() {
            return parkCode;
        }

        /**
         * Sets park code.
         *
         * @param parkCode the park code
         */
        public void setParkCode(String parkCode) {
            this.parkCode = parkCode;
        }

        /**
         * Gets park name.
         *
         * @return the park name
         */
        public String getParkName() {
            return parkName;
        }

        /**
         * Sets park name.
         *
         * @param parkName the park name
         */
        public void setParkName(String parkName) {
            this.parkName = parkName;
        }

        /**
         * Gets order num.
         *
         * @return the order num
         */
        public String getOrderNum() {
            return orderNum;
        }

        /**
         * Sets order num.
         *
         * @param orderNum the order num
         */
        public void setOrderNum(String orderNum) {
            this.orderNum = orderNum;
        }

        /**
         * Gets plate num.
         *
         * @return the plate num
         */
        public String getPlateNum() {
            return plateNum;
        }

        /**
         * Sets plate num.
         *
         * @param plateNum the plate num
         */
        public void setPlateNum(String plateNum) {
            this.plateNum = plateNum;
        }

        /**
         * Gets channel name.
         *
         * @return the channel name
         */
        public String getChannelName() {
            return channelName;
        }

        /**
         * Sets channel name.
         *
         * @param channelName the channel name
         */
        public void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        /**
         * Gets type.
         *
         * @return the type
         */
        public Integer getType() {
            return type;
        }

        /**
         * Sets type.
         *
         * @param type the type
         */
        public void setType(Integer type) {
            this.type = type;
        }

        /**
         * Gets car type.
         *
         * @return the car type
         */
        public Integer getCarType() {
            return carType;
        }

        /**
         * Sets car type.
         *
         * @param carType the car type
         */
        public void setCarType(Integer carType) {
            this.carType = carType;
        }

        /**
         * Gets img url.
         *
         * @return the img url
         */
        public String getImgUrl() {
            return imgUrl;
        }

        /**
         * Sets img url.
         *
         * @param imgUrl the img url
         */
        public void setImgUrl(String imgUrl) {
            this.imgUrl = imgUrl;
        }

        /**
         * Gets none enter flag.
         *
         * @return the none enter flag
         */
        public Integer getNoneEnterFlag() {
            return noneEnterFlag;
        }

        /**
         * Sets none enter flag.
         *
         * @param noneEnterFlag the none enter flag
         */
        public void setNoneEnterFlag(Integer noneEnterFlag) {
            this.noneEnterFlag = noneEnterFlag;
        }

        /**
         * Gets plate color.
         *
         * @return the plate color
         */
        public String getPlateColor() {
            return plateColor;
        }

        /**
         * Sets plate color.
         *
         * @param plateColor the plate color
         */
        public void setPlateColor(String plateColor) {
            this.plateColor = plateColor;
        }

        /**
         * Gets enter time.
         *
         * @return the enter time
         */
        public Long getEnterTime() {
            return enterTime;
        }

        /**
         * Sets enter time.
         *
         * @param enterTime the enter time
         */
        public void setEnterTime(Long enterTime) {
            this.enterTime = enterTime;
        }

        /**
         * Gets enter way.
         *
         * @return the enter way
         */
        public Integer getEnterWay() {
            return enterWay;
        }

        /**
         * Sets enter way.
         *
         * @param enterWay the enter way
         */
        public void setEnterWay(Integer enterWay) {
            this.enterWay = enterWay;
        }
    }
}
