package com.icetech.sdk.response.p2c.pay;

import com.icetech.sdk.response.BaseResponse;

import java.util.List;

/**
 * The type P 2 c query discount record response.
 *
 * @author wanggang
 * @create 2021 -07-22 16:26
 */
public class P2cQueryDiscountRecordResponse extends BaseResponse {

    /**
     * 记录列表
     */
    private List<P2cQueryDiscountRecordItem> items;

    /**
     * Gets items.
     *
     * @return the items
     */
    public List<P2cQueryDiscountRecordItem> getItems() {
        return items;
    }

    /**
     * Sets items.
     *
     * @param items the items
     */
    public void setItems(List<P2cQueryDiscountRecordItem> items) {
        this.items = items;
    }

    /**
     * The type P 2 c query discount record.
     */
    public static class P2cQueryDiscountRecordItem {
        /**
         * 停车场编号
         */
        private String parkCode;

        /**
         * 停车场名称
         */
        private String parkName;

        /**
         * 订单号，确保订单号在此车场内的唯一性
         */
        private String orderNum;

        /**
         * 优惠券名称
         */
        private String discountName;

        /**
         * 优惠券编号
         */
        private String discountNo;

        /**
         * 优惠内容
         */
        private String amount;

        /**
         * 状态(0未使用1已使用默认0)
         */
        private Integer status;

        /**
         * 优惠类型1全免2减免时间3减免金额4折扣
         */
        private Integer type;

        /**
         * Gets park code.
         *
         * @return the park code
         */
        public String getParkCode() {
            return parkCode;
        }

        /**
         * Sets park code.
         *
         * @param parkCode the park code
         */
        public void setParkCode(String parkCode) {
            this.parkCode = parkCode;
        }

        /**
         * Gets park name.
         *
         * @return the park name
         */
        public String getParkName() {
            return parkName;
        }

        /**
         * Sets park name.
         *
         * @param parkName the park name
         */
        public void setParkName(String parkName) {
            this.parkName = parkName;
        }

        /**
         * Gets order num.
         *
         * @return the order num
         */
        public String getOrderNum() {
            return orderNum;
        }

        /**
         * Sets order num.
         *
         * @param orderNum the order num
         */
        public void setOrderNum(String orderNum) {
            this.orderNum = orderNum;
        }

        /**
         * Gets discount name.
         *
         * @return the discount name
         */
        public String getDiscountName() {
            return discountName;
        }

        /**
         * Sets discount name.
         *
         * @param discountName the discount name
         */
        public void setDiscountName(String discountName) {
            this.discountName = discountName;
        }

        /**
         * Gets discount no.
         *
         * @return the discount no
         */
        public String getDiscountNo() {
            return discountNo;
        }

        /**
         * Sets discount no.
         *
         * @param discountNo the discount no
         */
        public void setDiscountNo(String discountNo) {
            this.discountNo = discountNo;
        }

        /**
         * Gets amount.
         *
         * @return the amount
         */
        public String getAmount() {
            return amount;
        }

        /**
         * Sets amount.
         *
         * @param amount the amount
         */
        public void setAmount(String amount) {
            this.amount = amount;
        }

        /**
         * Gets status.
         *
         * @return the status
         */
        public Integer getStatus() {
            return status;
        }

        /**
         * Sets status.
         *
         * @param status the status
         */
        public void setStatus(Integer status) {
            this.status = status;
        }

        /**
         * Gets type.
         *
         * @return the type
         */
        public Integer getType() {
            return type;
        }

        /**
         * Sets type.
         *
         * @param type the type
         */
        public void setType(Integer type) {
            this.type = type;
        }
    }
    
}
