package com.icetech.sdk.response.p2c.business;


import com.icetech.sdk.response.BaseResponse;

import java.util.List;

/**
 * 月卡产品表
 *
 * @author wanggy
 */
public class P2cQueryMonthProductResponse extends BaseResponse {

    /**
     * 月卡列表
     */
    private List<P2cQueryMonthProductItem> items;

    /**
     * Gets items.
     *
     * @return the items
     */
    public List<P2cQueryMonthProductItem> getItems() {
        return items;
    }

    /**
     * Sets items.
     *
     * @param items the items
     */
    public void setItems(List<P2cQueryMonthProductItem> items) {
        this.items = items;
    }

    /**
     * The type P 2 c query month product item.
     */
    public static class P2cQueryMonthProductItem {
        /**
         * 月卡套餐编号
         */
        private String productId;

        /**
         * 月卡产品名称
         */
        private String productName;

        /**
         * 产品面额
         */
        private Integer duration;

        /**
         * 销售金额
         */
        private String payMoney;

        /**
         * 月卡产品类型（1全天2分时段）
         */
        private String cardType;

        /**
         * 可用开始时间2018-10-31
         */
        private String startDate;

        /**
         * 可用结束时间2018-10-31
         */
        private String endDate;

        /**
         * 开始时间点 （月卡分时段时此参数必填产品可用时间段21:00:00）
         */
        private String startTime;

        /**
         * 结束时间点（跨天开始>结束，例如09:00:00）
         */
        private String endTime;

        /**
         * 购买渠道 0：仅平台可购买 1：平台和公众号均可购买 
         */
        private Integer buyWay;

        /**
         * 套餐所售状态 1 在售 2 停售 3 过期
         */
        private Integer productStatus;

        /**
         * Gets product id.
         *
         * @return the product id
         */
        public String getProductId() {
            return productId;
        }

        /**
         * Sets product id.
         *
         * @param productId the product id
         */
        public void setProductId(String productId) {
            this.productId = productId;
        }

        /**
         * Gets product name.
         *
         * @return the product name
         */
        public String getProductName() {
            return productName;
        }

        /**
         * Sets product name.
         *
         * @param productName the product name
         */
        public void setProductName(String productName) {
            this.productName = productName;
        }

        /**
         * Gets duration.
         *
         * @return the duration
         */
        public Integer getDuration() {
            return duration;
        }

        /**
         * Sets duration.
         *
         * @param duration the duration
         */
        public void setDuration(Integer duration) {
            this.duration = duration;
        }

        /**
         * Gets pay money.
         *
         * @return the pay money
         */
        public String getPayMoney() {
            return payMoney;
        }

        /**
         * Sets pay money.
         *
         * @param payMoney the pay money
         */
        public void setPayMoney(String payMoney) {
            this.payMoney = payMoney;
        }

        /**
         * Gets card type.
         *
         * @return the card type
         */
        public String getCardType() {
            return cardType;
        }

        /**
         * Sets card type.
         *
         * @param cardType the card type
         */
        public void setCardType(String cardType) {
            this.cardType = cardType;
        }

        /**
         * Gets start date.
         *
         * @return the start date
         */
        public String getStartDate() {
            return startDate;
        }

        /**
         * Sets start date.
         *
         * @param startDate the start date
         */
        public void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        /**
         * Gets end date.
         *
         * @return the end date
         */
        public String getEndDate() {
            return endDate;
        }

        /**
         * Sets end date.
         *
         * @param endDate the end date
         */
        public void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        /**
         * Gets start time.
         *
         * @return the start time
         */
        public String getStartTime() {
            return startTime;
        }

        /**
         * Sets start time.
         *
         * @param startTime the start time
         */
        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        /**
         * Gets end time.
         *
         * @return the end time
         */
        public String getEndTime() {
            return endTime;
        }

        /**
         * Sets end time.
         *
         * @param endTime the end time
         */
        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        /**
         * Gets buy way.
         *
         * @return the buy way
         */
        public Integer getBuyWay() {
            return buyWay;
        }

        /**
         * Sets buy way.
         *
         * @param buyWay the buy way
         */
        public void setBuyWay(Integer buyWay) {
            this.buyWay = buyWay;
        }

        /**
         * Gets product status.
         *
         * @return the product status
         */
        public Integer getProductStatus() {
            return productStatus;
        }

        /**
         * Sets product status.
         *
         * @param productStatus the product status
         */
        public void setProductStatus(Integer productStatus) {
            this.productStatus = productStatus;
        }
    }
    
}
