package com.icetech.sdk.response.p2c.business;

import com.icetech.sdk.response.BaseResponse;

import java.io.Serializable;
import java.util.List;

/**
 * Description QueryMonthCardsResponse
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/11 17:41
 */
public class P2cQueryMonthCardsResponse extends BaseResponse {

    /**
     * 查询月卡总数
     */
    private String totalSize;

    /**
     * 查询月卡列表
     */
    private List<MonthCards> mothCards;

    /**
     * Gets total size.
     *
     * @return the total size
     */
    public String getTotalSize() {
        return totalSize;
    }

    /**
     * Sets total size.
     *
     * @param totalSize the total size
     */
    public void setTotalSize(String totalSize) {
        this.totalSize = totalSize;
    }

    /**
     * Gets moth cards.
     *
     * @return the moth cards
     */
    public List<MonthCards> getMothCards() {
        return mothCards;
    }

    /**
     * Sets moth cards.
     *
     * @param mothCards the moth cards
     */
    public void setMothCards(List<MonthCards> mothCards) {
        this.mothCards = mothCards;
    }

    /**
     * The type Month cards.
     */
    public static class MonthCards {

        /**
         * 月卡记录编号
         */
        private Long cardId;

        /**
         * 月卡套餐编号
         */
        private String productId;

        /**
         * 月卡套餐名称
         */
        private String prodName;

        /**
         * 月卡申办性质，详情查看数据定义部分
         */
        private Integer cardProperty;

        /**
         * 用户/公司名称
         */
        private String cardOwner;

        /**
         * 车牌号，（多个以 / 分割）
         */
        private String plateNum;

        /**
         * 手机号
         */
        private String phone;

        /**
         * 车位数量，默认为1，可支持多车位多车
         */
        private Integer plotCount;

        /**
         * 车位号 多个以”/“连接
         */
        private String plotNum;

        /**
         * 月卡有效开始日期，格式为年-月-日
         */
        private String startTime;

        /**
         * 月卡有效结束日期，格式为年-月-日
         */
        private String endTime;

        /**
         * 卡状态（1：正常，2：禁用）
         */
        private Integer cardStatus;

        /**
         * 月卡区域
         */
        private List<RegionData> regionData;

        /**
         * Gets card id.
         *
         * @return the card id
         */
        public Long getCardId() {
            return cardId;
        }

        /**
         * Sets card id.
         *
         * @param cardId the card id
         */
        public void setCardId(Long cardId) {
            this.cardId = cardId;
        }

        /**
         * Gets product id.
         *
         * @return the product id
         */
        public String getProductId() {
            return productId;
        }

        /**
         * Sets product id.
         *
         * @param productId the product id
         */
        public void setProductId(String productId) {
            this.productId = productId;
        }

        /**
         * Gets prod name.
         *
         * @return the prod name
         */
        public String getProdName() {
            return prodName;
        }

        /**
         * Sets prod name.
         *
         * @param prodName the prod name
         */
        public void setProdName(String prodName) {
            this.prodName = prodName;
        }

        /**
         * Gets card property.
         *
         * @return the card property
         */
        public Integer getCardProperty() {
            return cardProperty;
        }

        /**
         * Sets card property.
         *
         * @param cardProperty the card property
         */
        public void setCardProperty(Integer cardProperty) {
            this.cardProperty = cardProperty;
        }

        /**
         * Gets card owner.
         *
         * @return the card owner
         */
        public String getCardOwner() {
            return cardOwner;
        }

        /**
         * Sets card owner.
         *
         * @param cardOwner the card owner
         */
        public void setCardOwner(String cardOwner) {
            this.cardOwner = cardOwner;
        }

        /**
         * Gets plate num.
         *
         * @return the plate num
         */
        public String getPlateNum() {
            return plateNum;
        }

        /**
         * Sets plate num.
         *
         * @param plateNum the plate num
         */
        public void setPlateNum(String plateNum) {
            this.plateNum = plateNum;
        }

        /**
         * Gets phone.
         *
         * @return the phone
         */
        public String getPhone() {
            return phone;
        }

        /**
         * Sets phone.
         *
         * @param phone the phone
         */
        public void setPhone(String phone) {
            this.phone = phone;
        }

        /**
         * Gets plot count.
         *
         * @return the plot count
         */
        public Integer getPlotCount() {
            return plotCount;
        }

        /**
         * Sets plot count.
         *
         * @param plotCount the plot count
         */
        public void setPlotCount(Integer plotCount) {
            this.plotCount = plotCount;
        }

        /**
         * Gets plot num.
         *
         * @return the plot num
         */
        public String getPlotNum() {
            return plotNum;
        }

        /**
         * Sets plot num.
         *
         * @param plotNum the plot num
         */
        public void setPlotNum(String plotNum) {
            this.plotNum = plotNum;
        }

        /**
         * Gets start time.
         *
         * @return the start time
         */
        public String getStartTime() {
            return startTime;
        }

        /**
         * Sets start time.
         *
         * @param startTime the start time
         */
        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        /**
         * Gets end time.
         *
         * @return the end time
         */
        public String getEndTime() {
            return endTime;
        }

        /**
         * Sets end time.
         *
         * @param endTime the end time
         */
        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        /**
         * Gets card status.
         *
         * @return the card status
         */
        public Integer getCardStatus() {
            return cardStatus;
        }

        /**
         * Sets card status.
         *
         * @param cardStatus the card status
         */
        public void setCardStatus(Integer cardStatus) {
            this.cardStatus = cardStatus;
        }

        /**
         * Gets region data.
         *
         * @return the region data
         */
        public List<RegionData> getRegionData() {
            return regionData;
        }

        /**
         * Sets region data.
         *
         * @param regionData the region data
         */
        public void setRegionData(List<RegionData> regionData) {
            this.regionData = regionData;
        }

        /**
         * The type Region data.
         */
        public static class RegionData implements Serializable {

            /**
             * 区域编号
             */
            private String regionCode;

            /**
             * 区域名称
             */
            private String regionName;

            /**
             * Gets region code.
             *
             * @return the region code
             */
            public String getRegionCode() {
                return regionCode;
            }

            /**
             * Sets region code.
             *
             * @param regionCode the region code
             */
            public void setRegionCode(String regionCode) {
                this.regionCode = regionCode;
            }

            /**
             * Gets region name.
             *
             * @return the region name
             */
            public String getRegionName() {
                return regionName;
            }

            /**
             * Sets region name.
             *
             * @param regionName the region name
             */
            public void setRegionName(String regionName) {
                this.regionName = regionName;
            }
        }
        
    }
}
