package com.icetech.sdk.response.p2c.base;

import com.icetech.sdk.response.BaseResponse;

import java.io.Serializable;
import java.util.List;

/**
 * Description RegionListResponse
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/18 10:58
 */
public class P2cRegionListResponse extends BaseResponse {

    /**
     * 总记录数
     */
    private Long total;

    /**
     * 总页数
     */
    private String totalPage;

    /**
     * 返回数据结果
     */
    private List<RegionListItem> rows;

    /**
     * Gets total.
     *
     * @return the total
     */
    public Long getTotal() {
        return total;
    }

    /**
     * Sets total.
     *
     * @param total the total
     */
    public void setTotal(Long total) {
        this.total = total;
    }

    /**
     * Gets total page.
     *
     * @return the total page
     */
    public String getTotalPage() {
        return totalPage;
    }

    /**
     * Sets total page.
     *
     * @param totalPage the total page
     */
    public void setTotalPage(String totalPage) {
        this.totalPage = totalPage;
    }

    /**
     * Gets rows.
     *
     * @return the rows
     */
    public List<RegionListItem> getRows() {
        return rows;
    }

    /**
     * Sets rows.
     *
     * @param rows the rows
     */
    public void setRows(List<RegionListItem> rows) {
        this.rows = rows;
    }

    /**
     * The type Region list item.
     */
    public static class RegionListItem implements Serializable {

        /**
         * 分区编号
         */
        private String regionCode;

        /**
         * 停车场编号
         */
        private String parkCode;

        /**
         * 区域名称
         */
        private String regionName;

        /**
         * 区域泊位总数
         */
        private Integer regionPark;

        /**
         * 是否有子区域 1：有 2：无
         */
        private Integer hasInner;

        /**
         * 子区域数据 hasInner==1是此参数必填
         */
        private List<SonData> sonData;

        /**
         * Gets region code.
         *
         * @return the region code
         */
        public String getRegionCode() {
            return regionCode;
        }

        /**
         * Sets region code.
         *
         * @param regionCode the region code
         */
        public void setRegionCode(String regionCode) {
            this.regionCode = regionCode;
        }

        /**
         * Gets park code.
         *
         * @return the park code
         */
        public String getParkCode() {
            return parkCode;
        }

        /**
         * Sets park code.
         *
         * @param parkCode the park code
         */
        public void setParkCode(String parkCode) {
            this.parkCode = parkCode;
        }

        /**
         * Gets region name.
         *
         * @return the region name
         */
        public String getRegionName() {
            return regionName;
        }

        /**
         * Sets region name.
         *
         * @param regionName the region name
         */
        public void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        /**
         * Gets region park.
         *
         * @return the region park
         */
        public Integer getRegionPark() {
            return regionPark;
        }

        /**
         * Sets region park.
         *
         * @param regionPark the region park
         */
        public void setRegionPark(Integer regionPark) {
            this.regionPark = regionPark;
        }

        /**
         * Gets has inner.
         *
         * @return the has inner
         */
        public Integer getHasInner() {
            return hasInner;
        }

        /**
         * Sets has inner.
         *
         * @param hasInner the has inner
         */
        public void setHasInner(Integer hasInner) {
            this.hasInner = hasInner;
        }

        /**
         * Gets son data.
         *
         * @return the son data
         */
        public List<SonData> getSonData() {
            return sonData;
        }

        /**
         * Sets son data.
         *
         * @param sonData the son data
         */
        public void setSonData(List<SonData> sonData) {
            this.sonData = sonData;
        }

        /**
         * The type Son data.
         */
        public static class SonData implements Serializable {

            /**
             * 子区域名称
             */
            private String regionName;

            /**
             * 子分区编号
             */
            private String regionCode;

            /**
             * 子区域泊位总数
             */
            private Integer regionPark;

            /**
             * Gets region name.
             *
             * @return the region name
             */
            public String getRegionName() {
                return regionName;
            }

            /**
             * Sets region name.
             *
             * @param regionName the region name
             */
            public void setRegionName(String regionName) {
                this.regionName = regionName;
            }

            /**
             * Gets region code.
             *
             * @return the region code
             */
            public String getRegionCode() {
                return regionCode;
            }

            /**
             * Sets region code.
             *
             * @param regionCode the region code
             */
            public void setRegionCode(String regionCode) {
                this.regionCode = regionCode;
            }

            /**
             * Gets region park.
             *
             * @return the region park
             */
            public Integer getRegionPark() {
                return regionPark;
            }

            /**
             * Sets region park.
             *
             * @param regionPark the region park
             */
            public void setRegionPark(Integer regionPark) {
                this.regionPark = regionPark;
            }
        }
    }
}
