package com.icetech.sdk.response.p2c.base;

import com.icetech.sdk.response.BaseResponse;

import java.util.ArrayList;
import java.util.List;

/**
 * @author wanggang
 * @create 2022-07-15 15:10
 */
public class P2cQrcodeUrlResponse extends BaseResponse {

    /**
     * 场内支付二维码URL
     */
    private String inparkUrl;

    /**
     * 通道码集合
     */
    private List<ChannelUrls> channelUrls = new ArrayList<>();

    public String getInparkUrl() {
        return inparkUrl;
    }

    public void setInparkUrl(String inparkUrl) {
        this.inparkUrl = inparkUrl;
    }

    public List<ChannelUrls> getChannelUrls() {
        return channelUrls;
    }

    public void setChannelUrls(List<ChannelUrls> channelUrls) {
        this.channelUrls = channelUrls;
    }

    public static class ChannelUrls {

        /**
         * 通道编号
         */
        private String channelCode;

        /**
         * 出入口类型，1：入口，2：出口
         */
        private Integer gateType;

        /**
         *二维码URL
         */
        private String qrcodeUrl;

        public String getChannelCode() {
            return channelCode;
        }

        public void setChannelCode(String channelCode) {
            this.channelCode = channelCode;
        }

        public Integer getGateType() {
            return gateType;
        }

        public void setGateType(Integer gateType) {
            this.gateType = gateType;
        }

        public String getQrcodeUrl() {
            return qrcodeUrl;
        }

        public void setQrcodeUrl(String qrcodeUrl) {
            this.qrcodeUrl = qrcodeUrl;
        }
    }
}
