package com.icetech.sdk.response.p2c.base;

import com.icetech.sdk.response.BaseResponse;

import java.io.Serializable;
import java.util.List;

/**
 * Description ParkListResponse
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/8 16:36
 */
public class P2cParkListResponse extends BaseResponse {

    /**
     * 总记录数
     */
    private Long total;

    /**
     * 总页数
     */
    private String totalPage;

    /**
     * 返回数据结果
     */
    private List<ParkList> rows;

    /**
     * Gets total.
     *
     * @return the total
     */
    public Long getTotal() {
        return total;
    }

    /**
     * Sets total.
     *
     * @param total the total
     */
    public void setTotal(Long total) {
        this.total = total;
    }

    /**
     * Gets total page.
     *
     * @return the total page
     */
    public String getTotalPage() {
        return totalPage;
    }

    /**
     * Sets total page.
     *
     * @param totalPage the total page
     */
    public void setTotalPage(String totalPage) {
        this.totalPage = totalPage;
    }

    /**
     * Gets rows.
     *
     * @return the rows
     */
    public List<ParkList> getRows() {
        return rows;
    }

    /**
     * Sets rows.
     *
     * @param rows the rows
     */
    public void setRows(List<ParkList> rows) {
        this.rows = rows;
    }

    public static class ParkList implements Serializable {

        /**
         * 停车场编号
         */
        private String parkCode;

        /**
         * 停车场名称
         */
        private String parkName;

        /**
         * 省份名称
         */
        private String provinceName;

        /**
         * 城市名称
         */
        private String cityName;

        /**
         * 区名称
         */
        private String districtName;

        /**
         * 停车场地址
         */
        private String address;

        /**
         * 停车场总车位数
         */
        private Integer totalNum;

        /**
         * 空车位
         */
        private Integer freeSpace;

        /**
         * Gets park code.
         *
         * @return the park code
         */
        public String getParkCode() {
            return parkCode;
        }

        /**
         * Sets park code.
         *
         * @param parkCode the park code
         */
        public void setParkCode(String parkCode) {
            this.parkCode = parkCode;
        }

        /**
         * Gets park name.
         *
         * @return the park name
         */
        public String getParkName() {
            return parkName;
        }

        /**
         * Sets park name.
         *
         * @param parkName the park name
         */
        public void setParkName(String parkName) {
            this.parkName = parkName;
        }

        /**
         * Gets province name.
         *
         * @return the province name
         */
        public String getProvinceName() {
            return provinceName;
        }

        /**
         * Sets province name.
         *
         * @param provinceName the province name
         */
        public void setProvinceName(String provinceName) {
            this.provinceName = provinceName;
        }

        /**
         * Gets city name.
         *
         * @return the city name
         */
        public String getCityName() {
            return cityName;
        }

        /**
         * Sets city name.
         *
         * @param cityName the city name
         */
        public void setCityName(String cityName) {
            this.cityName = cityName;
        }

        /**
         * Gets district name.
         *
         * @return the district name
         */
        public String getDistrictName() {
            return districtName;
        }

        /**
         * Sets district name.
         *
         * @param districtName the district name
         */
        public void setDistrictName(String districtName) {
            this.districtName = districtName;
        }

        /**
         * Gets address.
         *
         * @return the address
         */
        public String getAddress() {
            return address;
        }

        /**
         * Sets address.
         *
         * @param address the address
         */
        public void setAddress(String address) {
            this.address = address;
        }

        /**
         * Gets total num.
         *
         * @return the total num
         */
        public Integer getTotalNum() {
            return totalNum;
        }

        /**
         * Sets total num.
         *
         * @param totalNum the total num
         */
        public void setTotalNum(Integer totalNum) {
            this.totalNum = totalNum;
        }

        /**
         * Gets free space.
         *
         * @return the free space
         */
        public Integer getFreeSpace() {
            return freeSpace;
        }

        /**
         * Sets free space.
         *
         * @param freeSpace the free space
         */
        public void setFreeSpace(Integer freeSpace) {
            this.freeSpace = freeSpace;
        }
    }
}
