package com.icetech.sdk.response.p2c.base;

import com.icetech.sdk.response.BaseResponse;

import java.io.Serializable;
import java.util.List;

/**
 * Description P2cParkChannelListResponse
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/8 16:36
 */
public class P2cParkChannelListResponse extends BaseResponse {

    /**
     * 总记录数
     */
    private Long total;

    /**
     * 总页数
     */
    private String totalPage;

    /**
     * 返回数据结果
     */
    private List<ParkChannelList> rows;

    /**
     * Gets total.
     *
     * @return the total
     */
    public Long getTotal() {
        return total;
    }

    /**
     * Sets total.
     *
     * @param total the total
     */
    public void setTotal(Long total) {
        this.total = total;
    }

    /**
     * Gets total page.
     *
     * @return the total page
     */
    public String getTotalPage() {
        return totalPage;
    }

    /**
     * Sets total page.
     *
     * @param totalPage the total page
     */
    public void setTotalPage(String totalPage) {
        this.totalPage = totalPage;
    }

    /**
     * Gets rows.
     *
     * @return the rows
     */
    public List<ParkChannelList> getRows() {
        return rows;
    }

    /**
     * Sets rows.
     *
     * @param rows the rows
     */
    public void setRows(List<ParkChannelList> rows) {
        this.rows = rows;
    }

    public static class ParkChannelList implements Serializable {

        /**
         * 停车场名称
         */
        private String parkName;

        /**
         * 通道名称
         */
        private String channelName;

        /**
         * 通道编号
         */
        private String channelCode;

        /**
         * 通道类型，1入口 2出口
         */
        private Integer inandoutType;

        /**
         * 是否是主通道，1=是0=否，默认为1
         */
        private Integer isMaster;

        /**
         * 是否收费 1=是 0=否
         */
        private Integer isFee;

        public String getParkName() {
            return parkName;
        }

        public void setParkName(String parkName) {
            this.parkName = parkName;
        }

        public String getChannelName() {
            return channelName;
        }

        public void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public String getChannelCode() {
            return channelCode;
        }

        public void setChannelCode(String channelCode) {
            this.channelCode = channelCode;
        }

        public Integer getInandoutType() {
            return inandoutType;
        }

        public void setInandoutType(Integer inandoutType) {
            this.inandoutType = inandoutType;
        }

        public Integer getIsMaster() {
            return isMaster;
        }

        public void setIsMaster(Integer isMaster) {
            this.isMaster = isMaster;
        }

        public Integer getIsFee() {
            return isFee;
        }

        public void setIsFee(Integer isFee) {
            this.isFee = isFee;
        }
    }
}
