package com.icetech.sdk.response.p2c.base;

import com.icetech.sdk.response.BaseResponse;

import java.util.List;

/**
 * Description P2cDistrictListResponse
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/11 09:39
 */
public class P2cDistrictListResponse extends BaseResponse {

    /**
     * 城市列表
     */
    private List<P2cDistrictItem> items;

    /**
     * Gets items.
     *
     * @return the items
     */
    public List<P2cDistrictItem> getItems() {
        return items;
    }

    /**
     * Sets items.
     *
     * @param items the items
     */
    public void setItems(List<P2cDistrictItem> items) {
        this.items = items;
    }

    /**
     * The type P 2 c district item.
     */
    public static class P2cDistrictItem {
        /**
         * 列表id编码（下级地区列表 upperId 入参时使用）
         */
        private Integer id;

        /**
         * 城市id
         */
        private Integer cityId;

        /**
         * 城市级名称
         */
        private String name;

        /**
         * 系统编号
         */
        private String code;

        /**
         * Gets id.
         *
         * @return the id
         */
        public Integer getId() {
            return id;
        }

        /**
         * Sets id.
         *
         * @param id the id
         */
        public void setId(Integer id) {
            this.id = id;
        }

        /**
         * Gets city id.
         *
         * @return the city id
         */
        public Integer getCityId() {
            return cityId;
        }

        /**
         * Sets city id.
         *
         * @param cityId the city id
         */
        public void setCityId(Integer cityId) {
            this.cityId = cityId;
        }

        /**
         * Gets name.
         *
         * @return the name
         */
        public String getName() {
            return name;
        }

        /**
         * Sets name.
         *
         * @param name the name
         */
        public void setName(String name) {
            this.name = name;
        }

        /**
         * Gets code.
         *
         * @return the code
         */
        public String getCode() {
            return code;
        }

        /**
         * Sets code.
         *
         * @param code the code
         */
        public void setCode(String code) {
            this.code = code;
        }
    }
}
