package com.icetech.sdk.response.p2c.base;

import com.icetech.sdk.response.BaseResponse;

import java.util.List;

/**
 * Description P2cCityListResponse
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/11 09:39
 */
public class P2cCityListResponse extends BaseResponse {

    /**
     * 城市列表
     */
    private List<P2cCityItem> items;

    public List<P2cCityItem> getItems() {
        return items;
    }

    public void setItems(List<P2cCityItem> items) {
        this.items = items;
    }

    public static class P2cCityItem {
        /**
         * 列表id编码（下级地区列表 upperId 入参时使用）
         */
        private Integer id;

        /**
         * 省份id
         */
        private Integer provinceId;

        /**
         * 城市级名称
         */
        private String name;

        /**
         * 系统编号
         */
        private String code;

        /**
         * Gets id.
         *
         * @return the id
         */
        public Integer getId() {
            return id;
        }

        /**
         * Sets id.
         *
         * @param id the id
         */
        public void setId(Integer id) {
            this.id = id;
        }

        /**
         * Gets province id.
         *
         * @return the province id
         */
        public Integer getProvinceId() {
            return provinceId;
        }

        /**
         * Sets province id.
         *
         * @param provinceId the province id
         */
        public void setProvinceId(Integer provinceId) {
            this.provinceId = provinceId;
        }

        /**
         * Gets name.
         *
         * @return the name
         */
        public String getName() {
            return name;
        }

        /**
         * Sets name.
         *
         * @param name the name
         */
        public void setName(String name) {
            this.name = name;
        }

        /**
         * Gets code.
         *
         * @return the code
         */
        public String getCode() {
            return code;
        }

        /**
         * Sets code.
         *
         * @param code the code
         */
        public void setCode(String code) {
            this.code = code;
        }
    }
}
