package com.icetech.sdk.response.p2c.base;

import com.icetech.sdk.response.BaseResponse;

import java.io.Serializable;
import java.util.List;


/**
 * @author wanggang
 * @create 2022-07-15 15:10
 */
public class P2cChannelDeviceDetailsResponse extends BaseResponse {
    /**
     * 通道编号
     */
    private String inandoutCode;

    /**
     * 通道名称
     */
    private String inandoutName;

    /**
     * 通道类型，1入口 2出口
     */
    private Integer inandoutType;

    /**
     * 是否是主通道 1=是 0=否，默认为1
     */
    private Integer isMaster;

    /**
     * 区域编号，预留字段，暂不支持多区域
     */
    private String regionCode;

    /**
     * 是否收费 1=是 0=否
     */
    private Integer isFee;

    /**
     * 是否允许临时车进出 0:不允许 1：允许，默认1
     */
    private Integer isAllowTempcarrun;

    /**
     * 是否允许无牌车扫码进出 0:不允许 1：允许，默认1
     */
    private Integer isAllowNocardrun;

    /**
     * 黄牌车是否允许进 0:不开启 1：开启，默认1
     */
    private Integer isAllowYellowcarrun;

    /**
     * 是否开启模糊识别 0:不开启 1：开启，默认0
     */
    private Integer isOpenVaguetype;

    /**
     * 模糊模式 0：去汉字 1：去汉字1位 2：去汉字2位
     */
    private Integer vaguetype;

    /**
     * 是否允许新能源车辆进出 0：不允许 1：允许
     */
    private Integer isAllowNewenergycarrun;

    /**
     * 是否允许预约车进出0：不允许，1：允许
     */
    private Integer isAllowVisitCar;

    /**
     * 是否允月卡车车进出0：不允许，1：允许
     */
    private Integer isAllowMonthCar;

    /**
     * 是否允许过期月卡车进出0：不允许，1：允许
     */
    private Integer isOverTimeMonth;

    /**
     * 过期天数 isOverTimeMonth=1必填
     */
    private Integer overTimeDay;

    /**
     * 过期卡是否按月卡处理0：否，1：是 isOverTimeMonth=1必
     */
    private Integer overTimeMonthlyCard;

    /**
     * 是否允许多位多车月卡车进出1=是 0=否，默认
     */
    private Integer isAllowAbcar;

    /**
     * 是否允许黑名单车进出0：不允许，1：允许，默认0
     */
    private Integer isAllowBackCar;

    /**
     * 是否允许储值卡车进出0：不允许，1：允许，默认1
     */
    private Integer isAllowStoredCar;

    /**
     * 是否允许Vip车进出0：不允许，1：允许，默认1
     */
    private Integer isAllowVipCar;

    /**
     * vip车类型，多个以逗号隔开
     */
    private String vipCarTypeId;

    /**
     * 设备信息
     */
    private List<ParkDevices> devices;

    public String getInandoutCode() {
        return inandoutCode;
    }

    public void setInandoutCode(String inandoutCode) {
        this.inandoutCode = inandoutCode;
    }

    public String getInandoutName() {
        return inandoutName;
    }

    public void setInandoutName(String inandoutName) {
        this.inandoutName = inandoutName;
    }

    public Integer getInandoutType() {
        return inandoutType;
    }

    public void setInandoutType(Integer inandoutType) {
        this.inandoutType = inandoutType;
    }

    public Integer getIsMaster() {
        return isMaster;
    }

    public void setIsMaster(Integer isMaster) {
        this.isMaster = isMaster;
    }

    public String getRegionCode() {
        return regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public Integer getIsFee() {
        return isFee;
    }

    public void setIsFee(Integer isFee) {
        this.isFee = isFee;
    }

    public Integer getIsAllowTempcarrun() {
        return isAllowTempcarrun;
    }

    public void setIsAllowTempcarrun(Integer isAllowTempcarrun) {
        this.isAllowTempcarrun = isAllowTempcarrun;
    }

    public Integer getIsAllowNocardrun() {
        return isAllowNocardrun;
    }

    public void setIsAllowNocardrun(Integer isAllowNocardrun) {
        this.isAllowNocardrun = isAllowNocardrun;
    }

    public Integer getIsAllowYellowcarrun() {
        return isAllowYellowcarrun;
    }

    public void setIsAllowYellowcarrun(Integer isAllowYellowcarrun) {
        this.isAllowYellowcarrun = isAllowYellowcarrun;
    }

    public Integer getIsOpenVaguetype() {
        return isOpenVaguetype;
    }

    public void setIsOpenVaguetype(Integer isOpenVaguetype) {
        this.isOpenVaguetype = isOpenVaguetype;
    }

    public Integer getVaguetype() {
        return vaguetype;
    }

    public void setVaguetype(Integer vaguetype) {
        this.vaguetype = vaguetype;
    }

    public Integer getIsAllowNewenergycarrun() {
        return isAllowNewenergycarrun;
    }

    public void setIsAllowNewenergycarrun(Integer isAllowNewenergycarrun) {
        this.isAllowNewenergycarrun = isAllowNewenergycarrun;
    }

    public Integer getIsAllowVisitCar() {
        return isAllowVisitCar;
    }

    public void setIsAllowVisitCar(Integer isAllowVisitCar) {
        this.isAllowVisitCar = isAllowVisitCar;
    }

    public Integer getIsAllowMonthCar() {
        return isAllowMonthCar;
    }

    public void setIsAllowMonthCar(Integer isAllowMonthCar) {
        this.isAllowMonthCar = isAllowMonthCar;
    }

    public Integer getIsOverTimeMonth() {
        return isOverTimeMonth;
    }

    public void setIsOverTimeMonth(Integer isOverTimeMonth) {
        this.isOverTimeMonth = isOverTimeMonth;
    }

    public Integer getOverTimeDay() {
        return overTimeDay;
    }

    public void setOverTimeDay(Integer overTimeDay) {
        this.overTimeDay = overTimeDay;
    }

    public Integer getOverTimeMonthlyCard() {
        return overTimeMonthlyCard;
    }

    public void setOverTimeMonthlyCard(Integer overTimeMonthlyCard) {
        this.overTimeMonthlyCard = overTimeMonthlyCard;
    }

    public Integer getIsAllowAbcar() {
        return isAllowAbcar;
    }

    public void setIsAllowAbcar(Integer isAllowAbcar) {
        this.isAllowAbcar = isAllowAbcar;
    }

    public Integer getIsAllowBackCar() {
        return isAllowBackCar;
    }

    public void setIsAllowBackCar(Integer isAllowBackCar) {
        this.isAllowBackCar = isAllowBackCar;
    }

    public Integer getIsAllowStoredCar() {
        return isAllowStoredCar;
    }

    public void setIsAllowStoredCar(Integer isAllowStoredCar) {
        this.isAllowStoredCar = isAllowStoredCar;
    }

    public Integer getIsAllowVipCar() {
        return isAllowVipCar;
    }

    public void setIsAllowVipCar(Integer isAllowVipCar) {
        this.isAllowVipCar = isAllowVipCar;
    }

    public String getVipCarTypeId() {
        return vipCarTypeId;
    }

    public void setVipCarTypeId(String vipCarTypeId) {
        this.vipCarTypeId = vipCarTypeId;
    }

    public List<ParkDevices> getDevices() {
        return devices;
    }

    public void setDevices(List<ParkDevices> devices) {
        this.devices = devices;
    }

    public static class ParkDevices implements Serializable {

        /**
         * 设备编号
         */
        private String deviceNo;

        /**
         * 设备类型 0：超级盒子 1：摄像头 2:道闸 3:显示屏 4:语音对讲机
         */
        private Integer type;

        /**
         * 相机型号1：V82， 2：V83
         */
        private Integer modelType;

        /**
         * 相机序列号
         */
        private String serialNumber;

        /**
         * 设备IP
         */
        private String ip;

        /**
         * 设备端口
         */
        private String port;

        /**
         * 通讯方式 1:4G 2:有线3:wifi 4:相机485透传
         */
        private Integer callMethods;

        /**
         * 设备状态，0初始1在线2离线3故障
         */
        private Integer status;

        /**
         * 串口地址
         */
        private Integer serialaddr;

        /**
         * 波特率（0：1200，1：2400，2：4800，3：9600，4：19200，5：38400，6：115200，默认2400
         */
        private Integer baudrate;

        /**
         * 直播地址
         */
        private String videoUrl;

        /**
         * 第三方设备编码
         */
        private String thirdCode;

        /**
         * 是否主相机
         */
        private Integer isMaster;


        /**
         * 是否双摄像机
         */
        private Integer isDualcamera;


        /**
         * 备验证码-监控相机
         */
        private String verCode;


        /**
         * 端云相机协议版本号
         */
        private String protocolVer;


        /**
         * 端云相机协议类型，1：WS，2：阿里IOT
         */
        private Integer protocolType;

        /**
         * 产品型号
         */
        private String productModel;


        /**
         * 固件版本号
         */
        private String firmwareVersion;


        /**
         * 通讯协议是否自动切换 0:否  1：是 默认1
         */
        private Integer isAutoswitchCheck;

        /**
         * 语音对讲设备厂商类型 1：云翌  2：笛虎
         */
        private Integer voicevendorType;


        /**
         * 网络连接方式，1:无线，2:有线
         */
        private Integer connectionMode;

        /**
         * 无线网络运营商，1:移动，2:电信，3：联通，99：未
         */
        private Integer wirelessCarrier;

        /**
         * 无线网络运营商，1:移动，2:电信，3：联通，99：未知
         */
        private String network;

        /**
         * 是否连接语音屏显（0：否，1：是）
         */
        private Integer isVoiceLed;

        /**
         * 是否连接道闸（0：否，1：是）
         */
        private Integer isParkGate;

        public String getDeviceNo() {
            return deviceNo;
        }

        public void setDeviceNo(String deviceNo) {
            this.deviceNo = deviceNo;
        }

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public Integer getModelType() {
            return modelType;
        }

        public void setModelType(Integer modelType) {
            this.modelType = modelType;
        }

        public String getSerialNumber() {
            return serialNumber;
        }

        public void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public String getIp() {
            return ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public String getPort() {
            return port;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public Integer getCallMethods() {
            return callMethods;
        }

        public void setCallMethods(Integer callMethods) {
            this.callMethods = callMethods;
        }

        public Integer getStatus() {
            return status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Integer getSerialaddr() {
            return serialaddr;
        }

        public void setSerialaddr(Integer serialaddr) {
            this.serialaddr = serialaddr;
        }

        public Integer getBaudrate() {
            return baudrate;
        }

        public void setBaudrate(Integer baudrate) {
            this.baudrate = baudrate;
        }

        public String getVideoUrl() {
            return videoUrl;
        }

        public void setVideoUrl(String videoUrl) {
            this.videoUrl = videoUrl;
        }

        public String getThirdCode() {
            return thirdCode;
        }

        public void setThirdCode(String thirdCode) {
            this.thirdCode = thirdCode;
        }

        public Integer getIsMaster() {
            return isMaster;
        }

        public void setIsMaster(Integer isMaster) {
            this.isMaster = isMaster;
        }

        public Integer getIsDualcamera() {
            return isDualcamera;
        }

        public void setIsDualcamera(Integer isDualcamera) {
            this.isDualcamera = isDualcamera;
        }

        public String getVerCode() {
            return verCode;
        }

        public void setVerCode(String verCode) {
            this.verCode = verCode;
        }

        public String getProtocolVer() {
            return protocolVer;
        }

        public void setProtocolVer(String protocolVer) {
            this.protocolVer = protocolVer;
        }

        public Integer getProtocolType() {
            return protocolType;
        }

        public void setProtocolType(Integer protocolType) {
            this.protocolType = protocolType;
        }

        public String getProductModel() {
            return productModel;
        }

        public void setProductModel(String productModel) {
            this.productModel = productModel;
        }

        public String getFirmwareVersion() {
            return firmwareVersion;
        }

        public void setFirmwareVersion(String firmwareVersion) {
            this.firmwareVersion = firmwareVersion;
        }

        public Integer getIsAutoswitchCheck() {
            return isAutoswitchCheck;
        }

        public void setIsAutoswitchCheck(Integer isAutoswitchCheck) {
            this.isAutoswitchCheck = isAutoswitchCheck;
        }

        public Integer getVoicevendorType() {
            return voicevendorType;
        }

        public void setVoicevendorType(Integer voicevendorType) {
            this.voicevendorType = voicevendorType;
        }

        public Integer getConnectionMode() {
            return connectionMode;
        }

        public void setConnectionMode(Integer connectionMode) {
            this.connectionMode = connectionMode;
        }

        public Integer getWirelessCarrier() {
            return wirelessCarrier;
        }

        public void setWirelessCarrier(Integer wirelessCarrier) {
            this.wirelessCarrier = wirelessCarrier;
        }

        public String getNetwork() {
            return network;
        }

        public void setNetwork(String network) {
            this.network = network;
        }

        public Integer getIsVoiceLed() {
            return isVoiceLed;
        }

        public void setIsVoiceLed(Integer isVoiceLed) {
            this.isVoiceLed = isVoiceLed;
        }

        public Integer getIsParkGate() {
            return isParkGate;
        }

        public void setIsParkGate(Integer isParkGate) {
            this.isParkGate = isParkGate;
        }
    }

}
