package com.icetech.sdk.response.iot;

import com.icetech.sdk.response.BaseResponse;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class PlanListResponse extends BaseResponse implements Serializable {

    public PlanListResponse() {
    }

    private List<PlanDTO> items;

    public List<PlanDTO> getItems() {
        return items;
    }

    public void setItems(List<PlanDTO> items) {
        this.items = items;
    }

    @Override
    public String toString() {
        return "PlanListResponse{" +
                "items=" + items +
                '}';
    }

    public static class PlanDTO implements Serializable{
        private Long id;
        private Long userId;
        private String name;
        private Integer bindLimitSize;
        //并发限制
        private Integer maxConcurrentSize;
        //时长限制
        private Integer timeLength;
        //日期限制
        private Date begin;
        private Date end;

        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Long getUserId() {
            return userId;
        }

        public void setUserId(Long userId) {
            this.userId = userId;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getBindLimitSize() {
            return bindLimitSize;
        }

        public void setBindLimitSize(Integer bindLimitSize) {
            this.bindLimitSize = bindLimitSize;
        }

        public Integer getMaxConcurrentSize() {
            return maxConcurrentSize;
        }

        public void setMaxConcurrentSize(Integer maxConcurrentSize) {
            this.maxConcurrentSize = maxConcurrentSize;
        }

        public Integer getTimeLength() {
            return timeLength;
        }

        public void setTimeLength(Integer timeLength) {
            this.timeLength = timeLength;
        }

        public Date getBegin() {
            return begin;
        }

        public void setBegin(Date begin) {
            this.begin = begin;
        }

        public Date getEnd() {
            return end;
        }

        public void setEnd(Date end) {
            this.end = end;
        }

        @Override
        public String toString() {
            return "PlanDTO{" +
                    "id=" + id +
                    ", userId=" + userId +
                    ", name='" + name + '\'' +
                    ", bindLimitSize=" + bindLimitSize +
                    ", maxConcurrentSize=" + maxConcurrentSize +
                    ", timeLength=" + timeLength +
                    ", begin=" + begin +
                    ", end=" + end +
                    '}';
        }
    }
}
