package com.icetech.sdk.response.iot;

import com.icetech.sdk.response.BaseResponse;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class OpenDeviceInfoResponse extends BaseResponse {

    private List<OpenDeviceDTO> items;

    public List<OpenDeviceDTO> getItems() {
        return items;
    }

    public void setItems(List<OpenDeviceDTO> items) {
        this.items = items;
    }

    public static class OpenDeviceDTO implements Serializable {


        private Long id;
        //设备序列号
        private String deviceCode;
        //设备型号id
        private String deviceModel;
        //项目类型id
        private String project;
        //设备ip
        private String deviceIp;
        //出货订单号
        private String orderId;
        //出货版本,可理解为稳定版本
        private String deliveryVersion;
        //当前版本信息
        private String currentVersion;
        //渠道编号
        private String channelName;
        //客户id
        private String userId;
        //出货日期
        private Date deliveryDate;
        //代工厂编码
        private String factoryNumber;
        //备注信息
        private String comment;

        @Override
        public String toString() {
            return "OpenDeviceDTO{" +
                    "id=" + id +
                    ", deviceCode='" + deviceCode + '\'' +
                    ", deviceModel='" + deviceModel + '\'' +
                    ", project='" + project + '\'' +
                    ", deviceIp='" + deviceIp + '\'' +
                    ", orderId='" + orderId + '\'' +
                    ", deliveryVersion='" + deliveryVersion + '\'' +
                    ", currentVersion='" + currentVersion + '\'' +
                    ", channelName='" + channelName + '\'' +
                    ", userId='" + userId + '\'' +
                    ", deliveryDate=" + deliveryDate +
                    ", factoryNumber='" + factoryNumber + '\'' +
                    ", comment='" + comment + '\'' +
                    '}';
        }

        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getDeviceCode() {
            return deviceCode;
        }

        public void setDeviceCode(String deviceCode) {
            this.deviceCode = deviceCode;
        }

        public String getDeviceModel() {
            return deviceModel;
        }

        public void setDeviceModel(String deviceModel) {
            this.deviceModel = deviceModel;
        }

        public String getProject() {
            return project;
        }

        public void setProject(String project) {
            this.project = project;
        }

        public String getDeviceIp() {
            return deviceIp;
        }

        public void setDeviceIp(String deviceIp) {
            this.deviceIp = deviceIp;
        }

        public String getOrderId() {
            return orderId;
        }

        public void setOrderId(String orderId) {
            this.orderId = orderId;
        }

        public String getDeliveryVersion() {
            return deliveryVersion;
        }

        public void setDeliveryVersion(String deliveryVersion) {
            this.deliveryVersion = deliveryVersion;
        }

        public String getCurrentVersion() {
            return currentVersion;
        }

        public void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        public String getChannelName() {
            return channelName;
        }

        public void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public String getUserId() {
            return userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public Date getDeliveryDate() {
            return deliveryDate;
        }

        public void setDeliveryDate(Date deliveryDate) {
            this.deliveryDate = deliveryDate;
        }

        public String getFactoryNumber() {
            return factoryNumber;
        }

        public void setFactoryNumber(String factoryNumber) {
            this.factoryNumber = factoryNumber;
        }

        public String getComment() {
            return comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }

    @Override
    public String toString() {
        return "OpenDeviceInfoResponse{" +
                "items=" + items +
                '}';
    }
}
