/*
package com.icetech.sdk.response.iot;

import com.icetech.sdk.response.BaseResponse;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FindGroupResponse extends BaseResponse {

    List<GroupDTO> items;

    public FindGroupResponse() {
    }

    public List<GroupDTO> getItems() {
        return items;
    }

    public void setItems(List<GroupDTO> items) {
        this.items = items;
    }

    public static class GroupDTO implements Serializable {

        private Long id;

        private String name;

        private String address;

        private String city;

        private String company;

        private Long parentId;

        private Integer concurrentLimit;

        private List<GroupDTO> children = new ArrayList<>();

        public void addChild(GroupDTO child) {
            this.children.add(child);
        }


        public boolean isRoot() {
            return Objects.isNull(parentId);
        }

        @Override
        public String toString() {
            return "GroupDTO{" +
                    "id=" + id +
                    ", name='" + name + '\'' +
                    ", address='" + address + '\'' +
                    ", city='" + city + '\'' +
                    ", company='" + company + '\'' +
                    ", parentId=" + parentId +
                    ", concurrentLimit=" + concurrentLimit +
                    ", children=" + children +
                    '}';
        }
    }

    @Override
    public String toString() {
        return "FindGroupResponse{" +
                "items=" + items +
                '}';
    }
}
*/
