package com.icetech.sdk.response;

import com.alibaba.fastjson.annotation.JSONField;

import java.util.Objects;

/**
 * @author wgy
 */
public abstract class BaseResponse {

    @JSONField(name = "request_id")
    private String requestId;
    
    @JSONField(name = "error_response")
    private ErrorResponse errorResponse;

    @JSONField(serialize = false)
    public boolean isSuccess() {
        return Objects.isNull(getErrorResponse());
    }

    public static class ErrorResponse {
        @JSONField(name = "request_id")
        private String requestId;
        private String code;
        private String msg;
        @JSONField(name = "sub_code")
        private String subCode;
        @JSONField(name = "sub_msg")
        private String subMsg;
        public String getRequestId() {
            return requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMsg() {
            return msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public String getSubCode() {
            return subCode;
        }

        public void setSubCode(String subCode) {
            this.subCode = subCode;
        }

        public String getSubMsg() {
            return subMsg;
        }

        public void setSubMsg(String subMsg) {
            this.subMsg = subMsg;
        }
    }

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }


    public ErrorResponse getErrorResponse() {
        return errorResponse;
    }

    public void setErrorResponse(ErrorResponse errorResponse) {
        this.errorResponse = errorResponse;
    }
}
