package com.icetech.sdk.request.p2c.rule;

import com.alibaba.fastjson.JSON;
import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.rule.P2cLedSoundResponse;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * Description LedSoundRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/15 18:08
 */
public class P2cLedSoundRequest extends BaseRequest<P2cLedSoundResponse> {

    /**
     * 停车场编号
     */
    private String parkCode;

    /**
     * 音量配置，音量值范围1~10，声音依次由弱到强，默认为10
     */
    private Integer volumeValue;

    /**
     * 勿扰模式是否开启，0不开启，1开启，默认为0
     */
    private Integer quietHoursSwitch;

    /**
     * 勿扰模式开始时间，24小时制，如21:00；
     */
    private String quietStartTime;

    /**
     * 勿扰模式结束时间，24小时制，如07:00；；
     */
    private String quietEndTime;

    /**
     * 勿扰模式音量值，范围1~10，默认为1
     */
    private Integer quietVolumeValue;

    /**
     * 语音配置
     */
    private List<SoundConfig> soundConfig;

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    /**
     * Gets volume value.
     *
     * @return the volume value
     */
    public Integer getVolumeValue() {
        return volumeValue;
    }

    /**
     * Sets volume value.
     *
     * @param volumeValue the volume value
     */
    public void setVolumeValue(Integer volumeValue) {
        this.volumeValue = volumeValue;
    }

    /**
     * Gets quiet hours switch.
     *
     * @return the quiet hours switch
     */
    public Integer getQuietHoursSwitch() {
        return quietHoursSwitch;
    }

    /**
     * Sets quiet hours switch.
     *
     * @param quietHoursSwitch the quiet hours switch
     */
    public void setQuietHoursSwitch(Integer quietHoursSwitch) {
        this.quietHoursSwitch = quietHoursSwitch;
    }

    /**
     * Gets quiet start time.
     *
     * @return the quiet start time
     */
    public String getQuietStartTime() {
        return quietStartTime;
    }

    /**
     * Sets quiet start time.
     *
     * @param quietStartTime the quiet start time
     */
    public void setQuietStartTime(String quietStartTime) {
        this.quietStartTime = quietStartTime;
    }

    /**
     * Gets quiet end time.
     *
     * @return the quiet end time
     */
    public String getQuietEndTime() {
        return quietEndTime;
    }

    /**
     * Sets quiet end time.
     *
     * @param quietEndTime the quiet end time
     */
    public void setQuietEndTime(String quietEndTime) {
        this.quietEndTime = quietEndTime;
    }

    /**
     * Gets quiet volume value.
     *
     * @return the quiet volume value
     */
    public Integer getQuietVolumeValue() {
        return quietVolumeValue;
    }

    /**
     * Sets quiet volume value.
     *
     * @param quietVolumeValue the quiet volume value
     */
    public void setQuietVolumeValue(Integer quietVolumeValue) {
        this.quietVolumeValue = quietVolumeValue;
    }

    /**
     * Gets sound config.
     *
     * @return the sound config
     */
    public List<SoundConfig> getSoundConfig() {
        return soundConfig;
    }

    /**
     * Sets sound config.
     *
     * @param soundConfig the sound config
     */
    public void setSoundConfig(List<SoundConfig> soundConfig) {
        this.soundConfig = soundConfig;
    }

    /**
     * The type Sound config.
     */
    public static class SoundConfig implements Serializable {
        /**
         * 播放类型 1：入场临时车、2：入场月卡车/内部车辆、3：入场无牌车、4：入场特殊车辆、5：出场收费车辆、6：出场支付成功、7：出场月卡车、8：出场无牌车、9：免费车辆（临时/特殊）、10" +
         *                 ".出场查无入场记录、11：临时车禁止通行、12：多位多车车位占用、13黑名单车辆进出场
         */
        private Integer soundType;

        /**
         * 动态内容编号和播放序号，多个之间用”+”符号链接，编号和序号之间用”_”符号链接，动态内容有：1：当前时间、2：今日限号、3：剩余车位、4：车牌号、5：车辆类型、6：月卡剩余天数、7：停车时长、8：需支付金额、9.一路平安、10" +
         *                 ".欢迎光临11请等待人工确认（比如：”4_1+5_3”,动态内容需要播放车牌号和车辆类型，车牌号排第一播放，车辆类型排第三播放）
         */
        private String dynamicContent;

        /**
         * 自定义内容和播放序号，多个之间用”+”符号链接，内容和序号之间用”_”符号链接(比如”一路平安_2+注意安全_4”,自定义内容中一路平安排第二播放，注意安全排第四播放)
         */
        private String customContent;

        /**
         * Gets sound type.
         *
         * @return the sound type
         */
        public Integer getSoundType() {
            return soundType;
        }

        /**
         * Sets sound type.
         *
         * @param soundType the sound type
         */
        public void setSoundType(Integer soundType) {
            this.soundType = soundType;
        }

        /**
         * Gets dynamic content.
         *
         * @return the dynamic content
         */
        public String getDynamicContent() {
            return dynamicContent;
        }

        /**
         * Sets dynamic content.
         *
         * @param dynamicContent the dynamic content
         */
        public void setDynamicContent(String dynamicContent) {
            this.dynamicContent = dynamicContent;
        }

        /**
         * Gets custom content.
         *
         * @return the custom content
         */
        public String getCustomContent() {
            return customContent;
        }

        /**
         * Sets custom content.
         *
         * @param customContent the custom content
         */
        public void setCustomContent(String customContent) {
            this.customContent = customContent;
        }
    }

    @Override
    protected String method() {
        return "p2c.led.sound";
    }

    @Override
    protected void buildBizContent(Map<String, Object> bizContent) {
        super.buildBizContent(bizContent);
        bizContent.put("soundConfig", JSON.toJSON(getSoundConfig()));
    }
}
