package com.icetech.sdk.request.p2c.rule;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.rule.P2cEditChargeRuleResponse;

/**
 * 编辑临时车收费规则参数
 *
 * @author zhangpengzhan
 * @date 2021 /1/7 11:18
 */
public class P2cEditChargeRuleRequest extends BaseRequest<P2cEditChargeRuleResponse> {
    /**
     * 云平台停车场编码
     */
    private String parkCode;

    /**
     * 规则Id
     */
    private String ruleId;

    /**
     * 规则名称
     */
    private String ruleName;

    /**
     * 免费停车时间 timeOne分钟
     */
    private Integer timeOne;

    /**
     * 前timeTwo分钟收费chargeThree元
     */
    private Integer timeTwo;

    /**
     * 前timeTwo分钟收费chargeThree元
     */
    private Integer chargeThree;

    /**
     * 之后每timeFour分钟收费chargeFive元
     */
    private Integer timeFour;

    /**
     * 之后每timeFour分钟收费chargeFive元
     */
    private Integer chargeFive;

    /**
     * 到timeSix时间的封顶价格chargeSeven 元（如果chargeSeven=-1，代表无封顶价格）
     */
    private Integer timeSix;

    /**
     * 到timeSix时间的封顶价格chargeSeven 元（如果chargeSeven=-1，代表无封顶价格）
     */
    private Integer chargeSeven;

    /**
     * 支持24小时多次进入最高收费价格chargeEight，按本次出场时间往前24小时之内的进场缴费总和。如果chargeEight为0，代表不支持24小时多次进入最高收费
     */
    private Integer chargeEight;

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    /**
     * Gets rule id.
     *
     * @return the rule id
     */
    public String getRuleId() {
        return ruleId;
    }

    /**
     * Sets rule id.
     *
     * @param ruleId the rule id
     */
    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    /**
     * Gets rule name.
     *
     * @return the rule name
     */
    public String getRuleName() {
        return ruleName;
    }

    /**
     * Sets rule name.
     *
     * @param ruleName the rule name
     */
    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    /**
     * Gets time one.
     *
     * @return the time one
     */
    public Integer getTimeOne() {
        return timeOne;
    }

    /**
     * Sets time one.
     *
     * @param timeOne the time one
     */
    public void setTimeOne(Integer timeOne) {
        this.timeOne = timeOne;
    }

    /**
     * Gets time two.
     *
     * @return the time two
     */
    public Integer getTimeTwo() {
        return timeTwo;
    }

    /**
     * Sets time two.
     *
     * @param timeTwo the time two
     */
    public void setTimeTwo(Integer timeTwo) {
        this.timeTwo = timeTwo;
    }

    /**
     * Gets charge three.
     *
     * @return the charge three
     */
    public Integer getChargeThree() {
        return chargeThree;
    }

    /**
     * Sets charge three.
     *
     * @param chargeThree the charge three
     */
    public void setChargeThree(Integer chargeThree) {
        this.chargeThree = chargeThree;
    }

    /**
     * Gets time four.
     *
     * @return the time four
     */
    public Integer getTimeFour() {
        return timeFour;
    }

    /**
     * Sets time four.
     *
     * @param timeFour the time four
     */
    public void setTimeFour(Integer timeFour) {
        this.timeFour = timeFour;
    }

    /**
     * Gets charge five.
     *
     * @return the charge five
     */
    public Integer getChargeFive() {
        return chargeFive;
    }

    /**
     * Sets charge five.
     *
     * @param chargeFive the charge five
     */
    public void setChargeFive(Integer chargeFive) {
        this.chargeFive = chargeFive;
    }

    /**
     * Gets time six.
     *
     * @return the time six
     */
    public Integer getTimeSix() {
        return timeSix;
    }

    /**
     * Sets time six.
     *
     * @param timeSix the time six
     */
    public void setTimeSix(Integer timeSix) {
        this.timeSix = timeSix;
    }

    /**
     * Gets charge seven.
     *
     * @return the charge seven
     */
    public Integer getChargeSeven() {
        return chargeSeven;
    }

    /**
     * Sets charge seven.
     *
     * @param chargeSeven the charge seven
     */
    public void setChargeSeven(Integer chargeSeven) {
        this.chargeSeven = chargeSeven;
    }

    /**
     * Gets charge eight.
     *
     * @return the charge eight
     */
    public Integer getChargeEight() {
        return chargeEight;
    }

    /**
     * Sets charge eight.
     *
     * @param chargeEight the charge eight
     */
    public void setChargeEight(Integer chargeEight) {
        this.chargeEight = chargeEight;
    }

    @Override
    protected String method() {
        return "p2c.edit.charge.rule";
    }
}
