package com.icetech.sdk.request.p2c.rule;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.rule.P2cEditChannelRuleResponse;

/**
 * 编辑通道权限接口
 *
 * @author zhangpengzhan
 * @date 2021 /1/12 9:56
 */
public class P2cEditChannelRuleRequest extends BaseRequest<P2cEditChannelRuleResponse> {
    
    /**
     * 停车场编号
     */
    private String parkCode;

    /**
     * 通道配置编号
     */
    private String channelId;

    /**
     * 是否允许临时车进出 0:不允许  1：允许 默认1
     */
    private Integer isAllowTempCarrun;

    /**
     * 是否允许蓝牌车进出 0:不允许  1：允许 默认1
     */
    private Integer isAllowBluerun;

    /**
     * 是否允许无牌车扫码进出 0:不允许  1：允许 默认1
     */
    private Integer isAllowNocardrun;

    /**
     * 黄牌车是否允许进 0:不开启  1：开启 默认0
     */
    private Integer isAllowYellowCarrun;

    /**
     * 是否开启模糊识别 0:不开启  1：开启 默认0
     */
    private Integer isOpenVaguetype;

    /**
     * 模糊模式 0：去汉字 1：去汉字1位 2：去汉字2位
     */
    private Integer vaguetype;

    /**
     * 是否允许新能源车辆进出 0：不允许 1：允许 默认1
     */
    private Integer isAllowNewenergyCarrun;

    /**
     * 是否允许预约车进出0：不允许，1：允许
     */
    private Integer isAllowVisitCar;

    /**
     * 是否允月卡车车进出0：不允许，1：允许
     */
    private Integer isAllowMonthCar;

    /**
     * 是否允许多位多车月卡车进出1=是 0=否
     */
    private Integer isAllowAbcar;

    /**
     * 是否允许储值卡车进出 0:不允许  1：允许 默认1
     */
    private Integer isAllowStoredCar;
    
    /**
     * 是否允许黑名单车进出1=是 0=否
     */
    private Integer isAllowBackCar;

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    /**
     * Gets channel id.
     *
     * @return the channel id
     */
    public String getChannelId() {
        return channelId;
    }

    /**
     * Sets channel id.
     *
     * @param channelId the channel id
     */
    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    /**
     * Gets is allow temp carrun.
     *
     * @return the is allow temp carrun
     */
    public Integer getIsAllowTempCarrun() {
        return isAllowTempCarrun;
    }

    /**
     * Sets is allow temp carrun.
     *
     * @param isAllowTempCarrun the is allow temp carrun
     */
    public void setIsAllowTempCarrun(Integer isAllowTempCarrun) {
        this.isAllowTempCarrun = isAllowTempCarrun;
    }

    /**
     * Gets is allow bluerun.
     *
     * @return the is allow bluerun
     */
    public Integer getIsAllowBluerun() {
        return isAllowBluerun;
    }

    /**
     * Sets is allow bluerun.
     *
     * @param isAllowBluerun the is allow bluerun
     */
    public void setIsAllowBluerun(Integer isAllowBluerun) {
        this.isAllowBluerun = isAllowBluerun;
    }

    /**
     * Gets is allow nocardrun.
     *
     * @return the is allow nocardrun
     */
    public Integer getIsAllowNocardrun() {
        return isAllowNocardrun;
    }

    /**
     * Sets is allow nocardrun.
     *
     * @param isAllowNocardrun the is allow nocardrun
     */
    public void setIsAllowNocardrun(Integer isAllowNocardrun) {
        this.isAllowNocardrun = isAllowNocardrun;
    }

    /**
     * Gets is allow yellow carrun.
     *
     * @return the is allow yellow carrun
     */
    public Integer getIsAllowYellowCarrun() {
        return isAllowYellowCarrun;
    }

    /**
     * Sets is allow yellow carrun.
     *
     * @param isAllowYellowCarrun the is allow yellow carrun
     */
    public void setIsAllowYellowCarrun(Integer isAllowYellowCarrun) {
        this.isAllowYellowCarrun = isAllowYellowCarrun;
    }

    /**
     * Gets is open vaguetype.
     *
     * @return the is open vaguetype
     */
    public Integer getIsOpenVaguetype() {
        return isOpenVaguetype;
    }

    /**
     * Sets is open vaguetype.
     *
     * @param isOpenVaguetype the is open vaguetype
     */
    public void setIsOpenVaguetype(Integer isOpenVaguetype) {
        this.isOpenVaguetype = isOpenVaguetype;
    }

    /**
     * Gets vaguetype.
     *
     * @return the vaguetype
     */
    public Integer getVaguetype() {
        return vaguetype;
    }

    /**
     * Sets vaguetype.
     *
     * @param vaguetype the vaguetype
     */
    public void setVaguetype(Integer vaguetype) {
        this.vaguetype = vaguetype;
    }

    /**
     * Gets is allow newenergy carrun.
     *
     * @return the is allow newenergy carrun
     */
    public Integer getIsAllowNewenergyCarrun() {
        return isAllowNewenergyCarrun;
    }

    /**
     * Sets is allow newenergy carrun.
     *
     * @param isAllowNewenergyCarrun the is allow newenergy carrun
     */
    public void setIsAllowNewenergyCarrun(Integer isAllowNewenergyCarrun) {
        this.isAllowNewenergyCarrun = isAllowNewenergyCarrun;
    }

    /**
     * Gets is allow visit car.
     *
     * @return the is allow visit car
     */
    public Integer getIsAllowVisitCar() {
        return isAllowVisitCar;
    }

    /**
     * Sets is allow visit car.
     *
     * @param isAllowVisitCar the is allow visit car
     */
    public void setIsAllowVisitCar(Integer isAllowVisitCar) {
        this.isAllowVisitCar = isAllowVisitCar;
    }

    /**
     * Gets is allow month car.
     *
     * @return the is allow month car
     */
    public Integer getIsAllowMonthCar() {
        return isAllowMonthCar;
    }

    /**
     * Sets is allow month car.
     *
     * @param isAllowMonthCar the is allow month car
     */
    public void setIsAllowMonthCar(Integer isAllowMonthCar) {
        this.isAllowMonthCar = isAllowMonthCar;
    }

    /**
     * Gets is allow abcar.
     *
     * @return the is allow abcar
     */
    public Integer getIsAllowAbcar() {
        return isAllowAbcar;
    }

    /**
     * Sets is allow abcar.
     *
     * @param isAllowAbcar the is allow abcar
     */
    public void setIsAllowAbcar(Integer isAllowAbcar) {
        this.isAllowAbcar = isAllowAbcar;
    }

    /**
     * Gets is allow stored car.
     *
     * @return the is allow stored car
     */
    public Integer getIsAllowStoredCar() {
        return isAllowStoredCar;
    }

    /**
     * Sets is allow stored car.
     *
     * @param isAllowStoredCar the is allow stored car
     */
    public void setIsAllowStoredCar(Integer isAllowStoredCar) {
        this.isAllowStoredCar = isAllowStoredCar;
    }

    /**
     * Gets is allow back car.
     *
     * @return the is allow back car
     */
    public Integer getIsAllowBackCar() {
        return isAllowBackCar;
    }

    /**
     * Sets is allow back car.
     *
     * @param isAllowBackCar the is allow back car
     */
    public void setIsAllowBackCar(Integer isAllowBackCar) {
        this.isAllowBackCar = isAllowBackCar;
    }

    @Override
    protected String method() {
        return "p2c.edit.channel.rule";
    }
}
