package com.icetech.sdk.request.p2c.rule;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.rule.P2cDelChargeRuleResponse;

/**
 * The type P 2 c del charge rule request.
 *
 * @author zhangpengzhan
 * @date 2021 /1/8 18:08
 */
public class P2cDelChargeRuleRequest extends BaseRequest<P2cDelChargeRuleResponse> {
    /**
     * 云平台停车场编码
     */
    private String parkCode;

    /**
     * 规则Id
     */
    private String ruleId;

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    /**
     * Gets rule id.
     *
     * @return the rule id
     */
    public String getRuleId() {
        return ruleId;
    }

    /**
     * Sets rule id.
     *
     * @param ruleId the rule id
     */
    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    @Override
    protected String method() {
        return "p2c.del.charge.rule";
    }
}
