package com.icetech.sdk.request.p2c.rule;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.rule.P2cDelChannelRuleResponse;

/**
 * The type P 2 c del channel rule request.
 *
 * @author zhangpengzhan
 * @date 2021 /1/18 15:18
 */
public class P2cDelChannelRuleRequest extends BaseRequest<P2cDelChannelRuleResponse> {
    /**
     * 停车场编号
     */
    private String parkCode;

    /**
     * 通道配置编号
     */
    private String channelId;

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    /**
     * Gets channel id.
     *
     * @return the channel id
     */
    public String getChannelId() {
        return channelId;
    }

    /**
     * Sets channel id.
     *
     * @param channelId the channel id
     */
    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    @Override
    protected String method() {
        return "p2c.del.channel.rule";
    }
}
