package com.icetech.sdk.request.p2c.rule;

import com.alibaba.fastjson.JSON;
import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.request.CurrencyChargeRule;
import com.icetech.sdk.response.p2c.rule.P2cCurrencyChargeRuleSetResponse;

import java.util.Map;

/**
 * @author wanggang
 * @create 2022-07-25 15:18
 */
public class P2cCurrencyChargeRuleSetRequest extends BaseRequest<P2cCurrencyChargeRuleSetResponse> {

    /**
     * 1=添加 2=修改 3=删除
     */
    private Integer operType;

    /**
     * 停车场编号
     */
    private String parkCode;

    /**
     * 是否默认计费规则，0：否，1：是，车辆计费时使用默认计费规则
     */
    private Integer isDefault;

    /**
     * 计费规则编号 时间+随机数小于16位
     */
    private String billtypecode;

    /**
     * 计费规则名称
     */
    private String billtypename;

    /**
     * 计费规则明细
     */
    private CurrencyChargeRule chargeRule;

    public Integer getOperType() {
        return operType;
    }

    public void setOperType(Integer operType) {
        this.operType = operType;
    }

    public String getParkCode() {
        return parkCode;
    }

    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    public Integer getIsDefault() {
        return isDefault;
    }

    public void setIsDefault(Integer isDefault) {
        this.isDefault = isDefault;
    }

    public String getBilltypecode() {
        return billtypecode;
    }

    public void setBilltypecode(String billtypecode) {
        this.billtypecode = billtypecode;
    }

    public String getBilltypename() {
        return billtypename;
    }

    public void setBilltypename(String billtypename) {
        this.billtypename = billtypename;
    }

    public CurrencyChargeRule getChargeRule() {
        return chargeRule;
    }

    public void setChargeRule(CurrencyChargeRule chargeRule) {
        this.chargeRule = chargeRule;
    }

    @Override
    protected void buildBizContent(Map<String, Object> bizContent) {
        super.buildBizContent(bizContent);
        bizContent.put("chargeRule", JSON.toJSON(getChargeRule()));
    }
    @Override
    protected String method() {
        return "p2c.currency.charge.rule.set";
    }
}
