package com.icetech.sdk.request.p2c.rule;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.rule.P2cChargeRuleListResponse;

/**
 * Description P2cChargeRuleListRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/15 17:50
 */
public class P2cChargeRuleListRequest extends BaseRequest<P2cChargeRuleListResponse> {

    /**
     * 停车场编号
     */
    private String parkCode;

    /**
     * 分页查询页码（默认1,每页10条）
     */
    private Integer pageNum;

    /**
     * 分页查询单页数量（默认20 小于1000）
     */
    private Integer pageSize;

    /**
     * 计费规则名称
     */
    private String billtypename;

    public String getParkCode() {
        return parkCode;
    }

    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getBilltypename() {
        return billtypename;
    }

    public void setBilltypename(String billtypename) {
        this.billtypename = billtypename;
    }

    @Override
    protected String method() {
        return "p2c.charge.rule.list";
    }
}
