package com.icetech.sdk.request.p2c.rule;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.rule.P2cChargeRuleDelResponse;

/**
 * Description ChargeRuleQueryRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wg
 * @version 1.0 @Date 2022/7/15 17:50
 */
public class P2cChargeRuleDelRequest extends BaseRequest<P2cChargeRuleDelResponse> {

    /**
     * 计费规则类型，1、通用自然天 2、白天夜间收费 3、24小时计费；
     */
    private Integer billtype;

    /**
     * 停车场编号
     */
    private String parkCode;

    /**
     * 计费规则编号 时间+随机数小于16位
     */
    private String billtypecode;

    /**
     * 计费规则名称
     */
    private String billtypename;

    public String getBilltypename() {
        return billtypename;
    }

    public void setBilltypename(String billtypename) {
        this.billtypename = billtypename;
    }

    /**
     * Gets billtype.
     *
     * @return the billtype
     */
    public Integer getBilltype() {
        return billtype;
    }

    /**
     * Sets billtype.
     *
     * @param billtype the billtype
     */
    public void setBilltype(Integer billtype) {
        this.billtype = billtype;
    }

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    /**
     * Gets billtypecode.
     *
     * @return the billtypecode
     */
    public String getBilltypecode() {
        return billtypecode;
    }

    /**
     * Sets billtypecode.
     *
     * @param billtypecode the billtypecode
     */
    public void setBilltypecode(String billtypecode) {
        this.billtypecode = billtypecode;
    }

    @Override
    protected String method() {
        return "p2c.charge.rule.del";
    }
}
