package com.icetech.sdk.request.p2c.pay;

import com.alibaba.fastjson.JSON;
import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.pay.P2cQueryFeeResponse;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * The type P 2 c query fee request.
 */
public class P2cQueryFeeRequest extends BaseRequest<P2cQueryFeeResponse> {

    /**
     * 停车场编号，由平台统一分配
     */
    private String parkCode;

    /**
     * 车牌号，通道编号不传时，车牌号必传
     */
    private String plateNum;

    /**
     * 会员卡号
     */
    private String cardNo;

    /**
     * 订单编号，传此值可提升查询效率
     */
    private String orderNum;

    /**
     * 通道编号（从云平台获取），车牌号不传时，通道编号必传；出口缴费时建议传此参数，否则可能会出现计费结果和出口语音播报费用不一致的问题
     */
    private String channelCode;

    /**
     * 抵扣明细约定
     */
    private List<DeductionDetail> deductionDetails;

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    /**
     * Gets plate num.
     *
     * @return the plate num
     */
    public String getPlateNum() {
        return plateNum;
    }

    /**
     * Sets plate num.
     *
     * @param plateNum the plate num
     */
    public void setPlateNum(String plateNum) {
        this.plateNum = plateNum;
    }

    /**
     * Gets card no.
     *
     * @return the card no
     */
    public String getCardNo() {
        return cardNo;
    }

    /**
     * Sets card no.
     *
     * @param cardNo the card no
     */
    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    /**
     * Gets order num.
     *
     * @return the order num
     */
    public String getOrderNum() {
        return orderNum;
    }

    /**
     * Sets order num.
     *
     * @param orderNum the order num
     */
    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    /**
     * Gets channel code.
     *
     * @return the channel code
     */
    public String getChannelCode() {
        return channelCode;
    }

    /**
     * Sets channel code.
     *
     * @param channelCode the channel code
     */
    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    /**
     * Gets deduction details.
     *
     * @return the deduction details
     */
    public List<DeductionDetail> getDeductionDetails() {
        return deductionDetails;
    }

    /**
     * Sets deduction details.
     *
     * @param deductionDetails the deduction details
     */
    public void setDeductionDetails(List<DeductionDetail> deductionDetails) {
        this.deductionDetails = deductionDetails;
    }

    /**
     * The type Deduction detail.
     */
    public static class DeductionDetail implements Serializable {

        /**
         * 抵扣类型（1：权益，2：补贴，3：券，4：积分）
         */
        public int type;

        /**
         * 抵扣标识（抵扣类型为4积分时，此项为积分数，其他均为唯一标识）
         */
        public String identify;

        /**
         * 抵扣时长
         */
        public int minutes;

        /**
         * 抵扣金额（由第三方会员系统根据时长换算而来，平台不做时长转金额的处理）
         */
        public double amount;

        /**
         * Gets type.
         *
         * @return the type
         */
        public int getType() {
            return type;
        }

        /**
         * Sets type.
         *
         * @param type the type
         */
        public void setType(int type) {
            this.type = type;
        }

        /**
         * Gets identify.
         *
         * @return the identify
         */
        public String getIdentify() {
            return identify;
        }

        /**
         * Sets identify.
         *
         * @param identify the identify
         */
        public void setIdentify(String identify) {
            this.identify = identify;
        }

        /**
         * Gets minutes.
         *
         * @return the minutes
         */
        public int getMinutes() {
            return minutes;
        }

        /**
         * Sets minutes.
         *
         * @param minutes the minutes
         */
        public void setMinutes(int minutes) {
            this.minutes = minutes;
        }

        /**
         * Gets amount.
         *
         * @return the amount
         */
        public double getAmount() {
            return amount;
        }

        /**
         * Sets amount.
         *
         * @param amount the amount
         */
        public void setAmount(double amount) {
            this.amount = amount;
        }
    }

    @Override
    protected String method() {
        return "p2c.query.fee";
    }

    @Override
    protected void buildBizContent(Map<String, Object> bizContent) {
        super.buildBizContent(bizContent);
        bizContent.put("deductionDetails", JSON.toJSON(getDeductionDetails()));
    }
}
