package com.icetech.sdk.request.p2c.pay;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.pay.P2cQueryExitRecordResponse;

/**
 * 离场推送查询请求
 *
 * @author wangzhiwei
 */
public class P2cQueryExitRecordRequest extends BaseRequest<P2cQueryExitRecordResponse> {
    
    /**
     * 车场编号
     */
    private String parkCode;
   
    /**
     * 当开始时间格式 yyyy-MM-dd HH:mm:ss
     */
    private String startTime;
    
    /**
     * 结束时间 yyyy-MM-dd HH:mm:ss
     */
    private String endTime;
    
    /**
     * 停车记录号
     */
    private String orderNum;

    /**
     * 页码
     */
    private Integer pageNo;
    /**
     * 分行业大小
     */
    private Integer pageSize;

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    /**
     * Gets start time.
     *
     * @return the start time
     */
    public String getStartTime() {
        return startTime;
    }

    /**
     * Sets start time.
     *
     * @param startTime the start time
     */
    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    /**
     * Gets end time.
     *
     * @return the end time
     */
    public String getEndTime() {
        return endTime;
    }

    /**
     * Sets end time.
     *
     * @param endTime the end time
     */
    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    /**
     * Gets order num.
     *
     * @return the order num
     */
    public String getOrderNum() {
        return orderNum;
    }

    /**
     * Sets order num.
     *
     * @param orderNum the order num
     */
    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    /**
     * Gets page no.
     *
     * @return the page no
     */
    public Integer getPageNo() {
        return pageNo;
    }

    /**
     * Sets page no.
     *
     * @param pageNo the page no
     */
    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    /**
     * Gets page size.
     *
     * @return the page size
     */
    public Integer getPageSize() {
        return pageSize;
    }

    /**
     * Sets page size.
     *
     * @param pageSize the page size
     */
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    protected String method() {
        return "p2c.query.exit.record";
    }
}
