package com.icetech.sdk.request.p2c.pay;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.pay.P2cQueryEnterRecordResponse;

/**
 * 入场推送查询请求
 *
 * @author wangzhiwei
 */
public class P2cQueryEnterRecordRequest extends BaseRequest<P2cQueryEnterRecordResponse> {
    /**
     * 车场编号
     */
    private String parkCode;
    /**
     * 开始时间
     */
    private String startTime;
    /**
     * 结束时间
     */
    private String endTime;
    /**
     * 停车记录号
     */
    private String orderNum;
    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 页码
     */
    private Integer pageNo;
    /**
     * 分行业大小
     */
    private Integer pageSize;

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    /**
     * Gets start time.
     *
     * @return the start time
     */
    public String getStartTime() {
        return startTime;
    }

    /**
     * Sets start time.
     *
     * @param startTime the start time
     */
    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    /**
     * Gets end time.
     *
     * @return the end time
     */
    public String getEndTime() {
        return endTime;
    }

    /**
     * Sets end time.
     *
     * @param endTime the end time
     */
    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    /**
     * Gets order num.
     *
     * @return the order num
     */
    public String getOrderNum() {
        return orderNum;
    }

    /**
     * Sets order num.
     *
     * @param orderNum the order num
     */
    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    /**
     * Gets page no.
     *
     * @return the page no
     */
    public Integer getPageNo() {
        return pageNo;
    }

    /**
     * Sets page no.
     *
     * @param pageNo the page no
     */
    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    /**
     * Gets page size.
     *
     * @return the page size
     */
    public Integer getPageSize() {
        return pageSize;
    }

    /**
     * Sets page size.
     *
     * @param pageSize the page size
     */
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getPlateNum() {
        return plateNum;
    }

    public void setPlateNum(String plateNum) {
        this.plateNum = plateNum;
    }

    @Override
    protected String method() {
        return "p2c.query.enter.record";
    }
}
